<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-11-18 12:21
 */
interface TaskorderDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Taskorder 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param taskorder primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Taskorder taskorder
 	 */
	public function insert($taskorder);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Taskorder taskorder
 	 */
	public function update($taskorder);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTitle($value);

	public function queryByStartdate($value);

	public function queryByEnddate($value);

	public function queryByProductId($value);

	public function queryByNum($value);


	public function deleteByTitle($value);

	public function deleteByStartdate($value);

	public function deleteByEnddate($value);

	public function deleteByProductId($value);

	public function deleteByNum($value);


}
?>