<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-02-26 15:13
 */
interface UsergroupadminDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Usergroupadmin 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param usergroupadmin primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Usergroupadmin usergroupadmin
 	 */
	public function insert($usergroupadmin);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Usergroupadmin usergroupadmin
 	 */
	public function update($usergroupadmin);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByPropertyid($value);

	public function queryByIsallowed($value);


	public function deleteByPropertyid($value);

	public function deleteByIsallowed($value);


}
?>