<?php
/**
 * Class that operate on table 'assetssale'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-08-13 04:25
 */
class AssetssaleMySqlDAO implements AssetssaleDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return AssetssaleMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM assetssale WHERE assetssaleid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM assetssale';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM assetssale ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param assetssale primary key
 	 */
	public function delete($assetssaleid){
		$sql = 'DELETE FROM assetssale WHERE assetssaleid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($assetssaleid);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param AssetssaleMySql assetssale
 	 */
	public function insert($assetssale){
		$sql = 'INSERT INTO assetssale (assetssaleclient, assetssalesave, assetssaleval, assetssalecomment, assetssaledateadd, assetssaledate, assetsid) VALUES (?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($assetssale->assetssaleclient);
		$sqlQuery->setNumber($assetssale->assetssalesave);
		$sqlQuery->set($assetssale->assetssaleval);
		$sqlQuery->setString2($assetssale->assetssalecomment);
		$sqlQuery->set($assetssale->assetssaledateadd);
		$sqlQuery->set($assetssale->assetssaledate);
		$sqlQuery->setNumber($assetssale->assetsid);

		$id = $this->executeInsert($sqlQuery);	
		$assetssale->assetssaleid = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param AssetssaleMySql assetssale
 	 */
	public function update($assetssale){
		$sql = 'UPDATE assetssale SET assetssaleclient = ?, assetssalesave = ?, assetssaleval = ?, assetssalecomment = ?, assetssaledateadd = ?, assetssaledate = ?, assetsid = ? WHERE assetssaleid = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($assetssale->assetssaleclient);
		$sqlQuery->setNumber($assetssale->assetssalesave);
		$sqlQuery->set($assetssale->assetssaleval);
		$sqlQuery->setString2($assetssale->assetssalecomment);
		$sqlQuery->set($assetssale->assetssaledateadd);
		$sqlQuery->set($assetssale->assetssaledate);
		$sqlQuery->setNumber($assetssale->assetsid);

		$sqlQuery->setNumber($assetssale->assetssaleid);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM assetssale';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByAssetssaleclient($value){
		$sql = 'SELECT * FROM assetssale WHERE assetssaleclient = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAssetssalesave($value){
		$sql = 'SELECT * FROM assetssale WHERE assetssalesave = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAssetssaleval($value){
		$sql = 'SELECT * FROM assetssale WHERE assetssaleval = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAssetssalecomment($value){
		$sql = 'SELECT * FROM assetssale WHERE assetssalecomment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAssetssaledateadd($value){
		$sql = 'SELECT * FROM assetssale WHERE assetssaledateadd = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAssetssaledate($value){
		$sql = 'SELECT * FROM assetssale WHERE assetssaledate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAssetsid($value){
		$sql = 'SELECT * FROM assetssale WHERE assetsid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByAssetssaleclient($value){
		$sql = 'DELETE FROM assetssale WHERE assetssaleclient = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAssetssalesave($value){
		$sql = 'DELETE FROM assetssale WHERE assetssalesave = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAssetssaleval($value){
		$sql = 'DELETE FROM assetssale WHERE assetssaleval = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAssetssalecomment($value){
		$sql = 'DELETE FROM assetssale WHERE assetssalecomment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAssetssaledateadd($value){
		$sql = 'DELETE FROM assetssale WHERE assetssaledateadd = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAssetssaledate($value){
		$sql = 'DELETE FROM assetssale WHERE assetssaledate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAssetsid($value){
		$sql = 'DELETE FROM assetssale WHERE assetsid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return AssetssaleMySql 
	 */
	protected function readRow($row){
		$assetssale = new Assetssale();
		
		$assetssale->assetssaleid = $row['assetssaleid'];
		$assetssale->assetssaleclient = $row['assetssaleclient'];
		$assetssale->assetssalesave = $row['assetssalesave'];
		$assetssale->assetssaleval = $row['assetssaleval'];
		$assetssale->assetssalecomment = $row['assetssalecomment'];
		$assetssale->assetssaledateadd = $row['assetssaledateadd'];
		$assetssale->assetssaledate = $row['assetssaledate'];
		$assetssale->assetsid = $row['assetsid'];

		return $assetssale;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return AssetssaleMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>