<?php

/**
 * Class that operate on table 'bankaccount'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class BankaccountMySqlDAO implements BankaccountDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BankaccountMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM bankaccount WHERE accountid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM bankaccount';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM bankaccount ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param bankaccount primary key
     */
    public function delete($accountid) {
        $sql = 'DELETE FROM bankaccount WHERE accountid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($accountid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BankaccountMySql bankaccount
     */
    public function insert($bankaccount, $comment) {
        $sql = 'INSERT INTO bankaccount (accountname, comment, accountnumber, accountbeginingbalance, accountdate, accountcurrencytype, bankid, userid, conditions,visa,visaDisPer,treeId) VALUES (?, "' . $comment . '", ?, ?, ?, ?, ?, ?, ?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($bankaccount->accountname);
        //$sqlQuery->set($bankaccount->comment);
        $sqlQuery->set($bankaccount->accountnumber);
        $sqlQuery->set($bankaccount->accountbeginingbalance);
        $sqlQuery->set($bankaccount->accountdate);
        $sqlQuery->set($bankaccount->accountcurrencytype);
        $sqlQuery->setNumber($bankaccount->bankid);
        $sqlQuery->setNumber($bankaccount->userid);
        $sqlQuery->setNumber($bankaccount->conditions);
        $sqlQuery->setNumber($bankaccount->visa);
        $sqlQuery->setNumber($bankaccount->visaDisPer);
        $sqlQuery->setNumber($bankaccount->treeId);

        $id = $this->executeInsert($sqlQuery);
        $bankaccount->accountid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BankaccountMySql bankaccount
     */
    public function update($bankaccount, $comment) {
        $sql = 'UPDATE bankaccount SET accountname = ?, comment = "' . $comment . '", accountnumber = ?, accountbeginingbalance = ?, accountdate = ?, accountcurrencytype = ?, bankid = ?, userid = ?, conditions = ?,visa = ?,visaDisPer = ?,treeId=? WHERE accountid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($bankaccount->accountname);
        //$sqlQuery->set($bankaccount->comment);
        $sqlQuery->set($bankaccount->accountnumber);
        $sqlQuery->set($bankaccount->accountbeginingbalance);
        $sqlQuery->set($bankaccount->accountdate);
        $sqlQuery->set($bankaccount->accountcurrencytype);
        $sqlQuery->setNumber($bankaccount->bankid);
        $sqlQuery->setNumber($bankaccount->userid);
        $sqlQuery->setNumber($bankaccount->conditions);
        $sqlQuery->setNumber($bankaccount->visa);
        $sqlQuery->setNumber($bankaccount->visaDisPer);
        $sqlQuery->setNumber($bankaccount->treeId);

        $sqlQuery->setNumber($bankaccount->accountid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM bankaccount';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByAccountname($value) {
        $sql = 'SELECT * FROM bankaccount WHERE accountname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM bankaccount WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountnumber($value) {
        $sql = 'SELECT * FROM bankaccount WHERE accountnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountbeginingbalance($value) {
        $sql = 'SELECT * FROM bankaccount WHERE accountbeginingbalance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountdate($value) {
        $sql = 'SELECT * FROM bankaccount WHERE accountdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountcurrencytype($value) {
        $sql = 'SELECT * FROM bankaccount WHERE accountcurrencytype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBankid($value) {
        $sql = 'SELECT * FROM bankaccount WHERE bankid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM bankaccount WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM bankaccount WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByAccountname($value) {
        $sql = 'DELETE FROM bankaccount WHERE accountname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM bankaccount WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountnumber($value) {
        $sql = 'DELETE FROM bankaccount WHERE accountnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountbeginingbalance($value) {
        $sql = 'DELETE FROM bankaccount WHERE accountbeginingbalance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountdate($value) {
        $sql = 'DELETE FROM bankaccount WHERE accountdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountcurrencytype($value) {
        $sql = 'DELETE FROM bankaccount WHERE accountcurrencytype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBankid($value) {
        $sql = 'DELETE FROM bankaccount WHERE bankid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM bankaccount WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM bankaccount WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BankaccountMySql
     */
    protected function readRow($row) {
        $bankaccount = new Bankaccount();

        $bankaccount->accountid = isset($row['accountid']) ? $row['accountid'] : '';
        $bankaccount->accountname = isset($row['accountname']) ? $row['accountname'] : '';
        $bankaccount->comment = isset($row['comment']) ? $row['comment'] : '';
        $bankaccount->accountnumber = isset($row['accountnumber']) ? $row['accountnumber'] : '';
        $bankaccount->accountbeginingbalance = isset($row['accountbeginingbalance']) ? $row['accountbeginingbalance'] : '';
        $bankaccount->accountdate = isset($row['accountdate']) ? $row['accountdate'] : '';
        $bankaccount->accountcurrencytype = isset($row['accountcurrencytype']) ? $row['accountcurrencytype'] : '';
        $bankaccount->bankid = isset($row['bankid']) ? $row['bankid'] : '';
        $bankaccount->userid = isset($row['userid']) ? $row['userid'] : '';
        $bankaccount->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $bankaccount->visa = isset($row['visa']) ? $row['visa'] : '';
        $bankaccount->visaDisPer = isset($row['visaDisPer']) ? $row['visaDisPer'] : '';
        $bankaccount->treeId = isset($row['treeId']) ? $row['treeId'] : '';

        //required
        $bankaccount->bankname = isset($row['bankname']) ? $row['bankname'] : '';


        return $bankaccount;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BankaccountMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>