<?php

/**
 * Class that operate on table 'billsbuy'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-02-20 09:04
 */
class BillsbuyMySqlDAO implements BillsbuyDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BillsbuyMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM billsbuy WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM billsbuy';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM billsbuy ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param billsbuy primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM billsbuy WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BillsbuyMySql billsbuy
     */
    public function insert($billsbuy) {
        $sql = 'INSERT INTO billsbuy (branchid, clientid, receivedate, billno, comment, billdate, serverdate, kashfid, cash, cashvalue, waitvalue, insurance, insurancecompanyid, customerpercent, customermax, customercarry, companyaccept, companycarry, card, cardvalue, paymentnetworkid, userid, deleted, kashftype, alloweddays, productstotalprice, kashfvalue, kashfdiscount, netbillvalue, discounttype, discountvalue, finalnetbillvalue, offline, uploaddate, pricetype, billstatus, approvalno, deliverytime, kashfplace, kashfdate, dailyentryid, insdiscountpercent, clientPayReceiptVal, netdiscountpercent, rondomtxt, attatch, approved, saveid, approveNo, approveFile, notifSeen) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billsbuy->branchid);
        $sqlQuery->setNumber($billsbuy->clientid);
        $sqlQuery->set($billsbuy->receivedate);
        $sqlQuery->set($billsbuy->billno);
        $sqlQuery->setString2($billsbuy->comment);
        $sqlQuery->set($billsbuy->billdate);
        $sqlQuery->set($billsbuy->serverdate);
        $sqlQuery->setNumber($billsbuy->kashfid);
        $sqlQuery->setNumber($billsbuy->cash);
        $sqlQuery->set($billsbuy->cashvalue);
        $sqlQuery->set($billsbuy->waitvalue);
        $sqlQuery->setNumber($billsbuy->insurance);
        $sqlQuery->setNumber($billsbuy->insurancecompanyid);
        $sqlQuery->set($billsbuy->customerpercent);
        $sqlQuery->set($billsbuy->customermax);
        $sqlQuery->set($billsbuy->customercarry);
        $sqlQuery->set($billsbuy->companyaccept);
        $sqlQuery->set($billsbuy->companycarry);
        $sqlQuery->setNumber($billsbuy->card);
        $sqlQuery->set($billsbuy->cardvalue);
        $sqlQuery->setNumber($billsbuy->paymentnetworkid);
        $sqlQuery->setNumber($billsbuy->userid);
        $sqlQuery->setNumber($billsbuy->deleted);
        $sqlQuery->setNumber($billsbuy->kashftype);
        $sqlQuery->setNumber($billsbuy->alloweddays);
        $sqlQuery->set($billsbuy->productstotalprice);
        $sqlQuery->set($billsbuy->kashfvalue);
        $sqlQuery->set($billsbuy->kashfdiscount);
        $sqlQuery->set($billsbuy->netbillvalue);
        $sqlQuery->setNumber($billsbuy->discounttype);
        $sqlQuery->set($billsbuy->discountvalue);
        $sqlQuery->set($billsbuy->finalnetbillvalue);
        $sqlQuery->setNumber($billsbuy->offline);
        $sqlQuery->set($billsbuy->uploaddate);
        $sqlQuery->setNumber($billsbuy->pricetype);
        $sqlQuery->setNumber($billsbuy->billstatus);
        $sqlQuery->set($billsbuy->approvalno);
        $sqlQuery->set($billsbuy->deliverytime);
        $sqlQuery->set($billsbuy->kashfplace);
        $sqlQuery->set($billsbuy->kashfdate);
        $sqlQuery->setNumber($billsbuy->dailyentryid);
        $sqlQuery->set($billsbuy->insdiscountpercent);
        $sqlQuery->set($billsbuy->clientPayReceiptVal);
        $sqlQuery->set($billsbuy->netdiscountpercent);
        $sqlQuery->set($billsbuy->rondomtxt);
        $sqlQuery->set($billsbuy->attatch);
        $sqlQuery->setNumber($billsbuy->approved);
        $sqlQuery->setNumber($billsbuy->saveid);
        $sqlQuery->set($billsbuy->approveNo);
        $sqlQuery->set($billsbuy->approveFile);
        $sqlQuery->setNumber($billsbuy->notifSeen);

        $id = $this->executeInsert($sqlQuery);
        $billsbuy->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BillsbuyMySql billsbuy
     */
    public function update($billsbuy) {
        $sql = 'UPDATE billsbuy SET branchid = ?, clientid = ?, receivedate = ?, billno = ?, comment = ?, billdate = ?, serverdate = ?, kashfid = ?, cash = ?, cashvalue = ?, waitvalue = ?, insurance = ?, insurancecompanyid = ?, customerpercent = ?, customermax = ?, customercarry = ?, companyaccept = ?, companycarry = ?, card = ?, cardvalue = ?, paymentnetworkid = ?, userid = ?, deleted = ?, kashftype = ?, alloweddays = ?, productstotalprice = ?, kashfvalue = ?, kashfdiscount = ?, netbillvalue = ?, discounttype = ?, discountvalue = ?, finalnetbillvalue = ?, offline = ?, uploaddate = ?, pricetype = ?, billstatus = ?, approvalno = ?, deliverytime = ?, kashfplace = ?, kashfdate = ?, dailyentryid = ?, insdiscountpercent = ?, clientPayReceiptVal = ?, netdiscountpercent = ?, rondomtxt = ?, attatch = ?, approved = ?, saveid = ?, approveNo = ?, approveFile = ?, notifSeen = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billsbuy->branchid);
        $sqlQuery->setNumber($billsbuy->clientid);
        $sqlQuery->set($billsbuy->receivedate);
        $sqlQuery->set($billsbuy->billno);
        $sqlQuery->setString2($billsbuy->comment);
        $sqlQuery->set($billsbuy->billdate);
        $sqlQuery->set($billsbuy->serverdate);
        $sqlQuery->setNumber($billsbuy->kashfid);
        $sqlQuery->setNumber($billsbuy->cash);
        $sqlQuery->set($billsbuy->cashvalue);
        $sqlQuery->set($billsbuy->waitvalue);
        $sqlQuery->setNumber($billsbuy->insurance);
        $sqlQuery->setNumber($billsbuy->insurancecompanyid);
        $sqlQuery->set($billsbuy->customerpercent);
        $sqlQuery->set($billsbuy->customermax);
        $sqlQuery->set($billsbuy->customercarry);
        $sqlQuery->set($billsbuy->companyaccept);
        $sqlQuery->set($billsbuy->companycarry);
        $sqlQuery->setNumber($billsbuy->card);
        $sqlQuery->set($billsbuy->cardvalue);
        $sqlQuery->setNumber($billsbuy->paymentnetworkid);
        $sqlQuery->setNumber($billsbuy->userid);
        $sqlQuery->setNumber($billsbuy->deleted);
        $sqlQuery->setNumber($billsbuy->kashftype);
        $sqlQuery->setNumber($billsbuy->alloweddays);
        $sqlQuery->set($billsbuy->productstotalprice);
        $sqlQuery->set($billsbuy->kashfvalue);
        $sqlQuery->set($billsbuy->kashfdiscount);
        $sqlQuery->set($billsbuy->netbillvalue);
        $sqlQuery->setNumber($billsbuy->discounttype);
        $sqlQuery->set($billsbuy->discountvalue);
        $sqlQuery->set($billsbuy->finalnetbillvalue);
        $sqlQuery->setNumber($billsbuy->offline);
        $sqlQuery->set($billsbuy->uploaddate);
        $sqlQuery->setNumber($billsbuy->pricetype);
        $sqlQuery->setNumber($billsbuy->billstatus);
        $sqlQuery->set($billsbuy->approvalno);
        $sqlQuery->set($billsbuy->deliverytime);
        $sqlQuery->set($billsbuy->kashfplace);
        $sqlQuery->set($billsbuy->kashfdate);
        $sqlQuery->setNumber($billsbuy->dailyentryid);
        $sqlQuery->set($billsbuy->insdiscountpercent);
        $sqlQuery->set($billsbuy->clientPayReceiptVal);
        $sqlQuery->set($billsbuy->netdiscountpercent);
        $sqlQuery->set($billsbuy->rondomtxt);
        $sqlQuery->set($billsbuy->attatch);
        $sqlQuery->setNumber($billsbuy->approved);
        $sqlQuery->setNumber($billsbuy->saveid);
        $sqlQuery->set($billsbuy->approveNo);
        $sqlQuery->set($billsbuy->approveFile);
        $sqlQuery->setNumber($billsbuy->notifSeen);

        $sqlQuery->setNumber($billsbuy->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM billsbuy';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBranchid($value) {
        $sql = 'SELECT * FROM billsbuy WHERE branchid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientid($value) {
        $sql = 'SELECT * FROM billsbuy WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReceivedate($value) {
        $sql = 'SELECT * FROM billsbuy WHERE receivedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillno($value) {
        $sql = 'SELECT * FROM billsbuy WHERE billno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM billsbuy WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBilldate($value) {
        $sql = 'SELECT * FROM billsbuy WHERE billdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByServerdate($value) {
        $sql = 'SELECT * FROM billsbuy WHERE serverdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByKashfid($value) {
        $sql = 'SELECT * FROM billsbuy WHERE kashfid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCash($value) {
        $sql = 'SELECT * FROM billsbuy WHERE cash = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCashvalue($value) {
        $sql = 'SELECT * FROM billsbuy WHERE cashvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWaitvalue($value) {
        $sql = 'SELECT * FROM billsbuy WHERE waitvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInsurance($value) {
        $sql = 'SELECT * FROM billsbuy WHERE insurance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInsurancecompanyid($value) {
        $sql = 'SELECT * FROM billsbuy WHERE insurancecompanyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCustomerpercent($value) {
        $sql = 'SELECT * FROM billsbuy WHERE customerpercent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCustomermax($value) {
        $sql = 'SELECT * FROM billsbuy WHERE customermax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCustomercarry($value) {
        $sql = 'SELECT * FROM billsbuy WHERE customercarry = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCompanyaccept($value) {
        $sql = 'SELECT * FROM billsbuy WHERE companyaccept = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCompanycarry($value) {
        $sql = 'SELECT * FROM billsbuy WHERE companycarry = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCard($value) {
        $sql = 'SELECT * FROM billsbuy WHERE card = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCardvalue($value) {
        $sql = 'SELECT * FROM billsbuy WHERE cardvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPaymentnetworkid($value) {
        $sql = 'SELECT * FROM billsbuy WHERE paymentnetworkid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM billsbuy WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeleted($value) {
        $sql = 'SELECT * FROM billsbuy WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByKashftype($value) {
        $sql = 'SELECT * FROM billsbuy WHERE kashftype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAlloweddays($value) {
        $sql = 'SELECT * FROM billsbuy WHERE alloweddays = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductstotalprice($value) {
        $sql = 'SELECT * FROM billsbuy WHERE productstotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByKashfvalue($value) {
        $sql = 'SELECT * FROM billsbuy WHERE kashfvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByKashfdiscount($value) {
        $sql = 'SELECT * FROM billsbuy WHERE kashfdiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNetbillvalue($value) {
        $sql = 'SELECT * FROM billsbuy WHERE netbillvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscounttype($value) {
        $sql = 'SELECT * FROM billsbuy WHERE discounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalue($value) {
        $sql = 'SELECT * FROM billsbuy WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByFinalnetbillvalue($value) {
        $sql = 'SELECT * FROM billsbuy WHERE finalnetbillvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOffline($value) {
        $sql = 'SELECT * FROM billsbuy WHERE offline = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUploaddate($value) {
        $sql = 'SELECT * FROM billsbuy WHERE uploaddate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPricetype($value) {
        $sql = 'SELECT * FROM billsbuy WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillstatus($value) {
        $sql = 'SELECT * FROM billsbuy WHERE billstatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByApprovalno($value) {
        $sql = 'SELECT * FROM billsbuy WHERE approvalno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeliverytime($value) {
        $sql = 'SELECT * FROM billsbuy WHERE deliverytime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByKashfplace($value) {
        $sql = 'SELECT * FROM billsbuy WHERE kashfplace = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByKashfdate($value) {
        $sql = 'SELECT * FROM billsbuy WHERE kashfdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDailyentryid($value) {
        $sql = 'SELECT * FROM billsbuy WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInsdiscountpercent($value) {
        $sql = 'SELECT * FROM billsbuy WHERE insdiscountpercent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientPayReceiptVal($value) {
        $sql = 'SELECT * FROM billsbuy WHERE clientPayReceiptVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNetdiscountpercent($value) {
        $sql = 'SELECT * FROM billsbuy WHERE netdiscountpercent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRondomtxt($value) {
        $sql = 'SELECT * FROM billsbuy WHERE rondomtxt = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAttatch($value) {
        $sql = 'SELECT * FROM billsbuy WHERE attatch = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByApproved($value) {
        $sql = 'SELECT * FROM billsbuy WHERE approved = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveid($value) {
        $sql = 'SELECT * FROM billsbuy WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByApproveNo($value) {
        $sql = 'SELECT * FROM billsbuy WHERE approveNo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByApproveFile($value) {
        $sql = 'SELECT * FROM billsbuy WHERE approveFile = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNotifSeen($value) {
        $sql = 'SELECT * FROM billsbuy WHERE notifSeen = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBranchid($value) {
        $sql = 'DELETE FROM billsbuy WHERE branchid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientid($value) {
        $sql = 'DELETE FROM billsbuy WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReceivedate($value) {
        $sql = 'DELETE FROM billsbuy WHERE receivedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillno($value) {
        $sql = 'DELETE FROM billsbuy WHERE billno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM billsbuy WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBilldate($value) {
        $sql = 'DELETE FROM billsbuy WHERE billdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByServerdate($value) {
        $sql = 'DELETE FROM billsbuy WHERE serverdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByKashfid($value) {
        $sql = 'DELETE FROM billsbuy WHERE kashfid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCash($value) {
        $sql = 'DELETE FROM billsbuy WHERE cash = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCashvalue($value) {
        $sql = 'DELETE FROM billsbuy WHERE cashvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWaitvalue($value) {
        $sql = 'DELETE FROM billsbuy WHERE waitvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInsurance($value) {
        $sql = 'DELETE FROM billsbuy WHERE insurance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInsurancecompanyid($value) {
        $sql = 'DELETE FROM billsbuy WHERE insurancecompanyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCustomerpercent($value) {
        $sql = 'DELETE FROM billsbuy WHERE customerpercent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCustomermax($value) {
        $sql = 'DELETE FROM billsbuy WHERE customermax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCustomercarry($value) {
        $sql = 'DELETE FROM billsbuy WHERE customercarry = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCompanyaccept($value) {
        $sql = 'DELETE FROM billsbuy WHERE companyaccept = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCompanycarry($value) {
        $sql = 'DELETE FROM billsbuy WHERE companycarry = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCard($value) {
        $sql = 'DELETE FROM billsbuy WHERE card = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCardvalue($value) {
        $sql = 'DELETE FROM billsbuy WHERE cardvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPaymentnetworkid($value) {
        $sql = 'DELETE FROM billsbuy WHERE paymentnetworkid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM billsbuy WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeleted($value) {
        $sql = 'DELETE FROM billsbuy WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByKashftype($value) {
        $sql = 'DELETE FROM billsbuy WHERE kashftype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAlloweddays($value) {
        $sql = 'DELETE FROM billsbuy WHERE alloweddays = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductstotalprice($value) {
        $sql = 'DELETE FROM billsbuy WHERE productstotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByKashfvalue($value) {
        $sql = 'DELETE FROM billsbuy WHERE kashfvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByKashfdiscount($value) {
        $sql = 'DELETE FROM billsbuy WHERE kashfdiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNetbillvalue($value) {
        $sql = 'DELETE FROM billsbuy WHERE netbillvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscounttype($value) {
        $sql = 'DELETE FROM billsbuy WHERE discounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalue($value) {
        $sql = 'DELETE FROM billsbuy WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByFinalnetbillvalue($value) {
        $sql = 'DELETE FROM billsbuy WHERE finalnetbillvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOffline($value) {
        $sql = 'DELETE FROM billsbuy WHERE offline = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUploaddate($value) {
        $sql = 'DELETE FROM billsbuy WHERE uploaddate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPricetype($value) {
        $sql = 'DELETE FROM billsbuy WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillstatus($value) {
        $sql = 'DELETE FROM billsbuy WHERE billstatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByApprovalno($value) {
        $sql = 'DELETE FROM billsbuy WHERE approvalno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeliverytime($value) {
        $sql = 'DELETE FROM billsbuy WHERE deliverytime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByKashfplace($value) {
        $sql = 'DELETE FROM billsbuy WHERE kashfplace = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByKashfdate($value) {
        $sql = 'DELETE FROM billsbuy WHERE kashfdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDailyentryid($value) {
        $sql = 'DELETE FROM billsbuy WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInsdiscountpercent($value) {
        $sql = 'DELETE FROM billsbuy WHERE insdiscountpercent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientPayReceiptVal($value) {
        $sql = 'DELETE FROM billsbuy WHERE clientPayReceiptVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNetdiscountpercent($value) {
        $sql = 'DELETE FROM billsbuy WHERE netdiscountpercent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRondomtxt($value) {
        $sql = 'DELETE FROM billsbuy WHERE rondomtxt = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAttatch($value) {
        $sql = 'DELETE FROM billsbuy WHERE attatch = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByApproved($value) {
        $sql = 'DELETE FROM billsbuy WHERE approved = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveid($value) {
        $sql = 'DELETE FROM billsbuy WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByApproveNo($value) {
        $sql = 'DELETE FROM billsbuy WHERE approveNo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByApproveFile($value) {
        $sql = 'DELETE FROM billsbuy WHERE approveFile = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNotifSeen($value) {
        $sql = 'DELETE FROM billsbuy WHERE notifSeen = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BillsbuyMySql
     */
    protected function readRow($row) {
        $billsbuy = new Billsbuy();

        $billsbuy->id = isset($row['id']) ? $row['id'] : '';
        $billsbuy->branchid = isset($row['branchid']) ? $row['branchid'] : '';
        $billsbuy->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $billsbuy->receivedate = isset($row['receivedate']) ? $row['receivedate'] : '';
        $billsbuy->billno = isset($row['billno']) ? $row['billno'] : '';
        $billsbuy->comment = isset($row['comment']) ? $row['comment'] : '';
        $billsbuy->billdate = isset($row['billdate']) ? $row['billdate'] : '';
        $billsbuy->serverdate = isset($row['serverdate']) ? $row['serverdate'] : '';
        $billsbuy->kashfid = isset($row['kashfid']) ? $row['kashfid'] : '';
        $billsbuy->cash = isset($row['cash']) ? $row['cash'] : '';
        $billsbuy->cashvalue = isset($row['cashvalue']) ? $row['cashvalue'] : '';
        $billsbuy->waitvalue = isset($row['waitvalue']) ? $row['waitvalue'] : '';
        $billsbuy->insurance = isset($row['insurance']) ? $row['insurance'] : '';
        $billsbuy->insurancecompanyid = isset($row['insurancecompanyid']) ? $row['insurancecompanyid'] : '';
        $billsbuy->customerpercent = isset($row['customerpercent']) ? $row['customerpercent'] : '';
        $billsbuy->customermax = isset($row['customermax']) ? $row['customermax'] : '';
        $billsbuy->customercarry = isset($row['customercarry']) ? $row['customercarry'] : '';
        $billsbuy->companyaccept = isset($row['companyaccept']) ? $row['companyaccept'] : '';
        $billsbuy->companycarry = isset($row['companycarry']) ? $row['companycarry'] : '';
        $billsbuy->card = isset($row['card']) ? $row['card'] : '';
        $billsbuy->cardvalue = isset($row['cardvalue']) ? $row['cardvalue'] : '';
        $billsbuy->paymentnetworkid = isset($row['paymentnetworkid']) ? $row['paymentnetworkid'] : '';
        $billsbuy->userid = isset($row['userid']) ? $row['userid'] : '';
        $billsbuy->deleted = isset($row['deleted']) ? $row['deleted'] : '';
        $billsbuy->kashftype = isset($row['kashftype']) ? $row['kashftype'] : '';
        $billsbuy->alloweddays = isset($row['alloweddays']) ? $row['alloweddays'] : '';
        $billsbuy->productstotalprice = isset($row['productstotalprice']) ? $row['productstotalprice'] : '';
        $billsbuy->kashfvalue = isset($row['kashfvalue']) ? $row['kashfvalue'] : '';
        $billsbuy->kashfdiscount = isset($row['kashfdiscount']) ? $row['kashfdiscount'] : '';
        $billsbuy->netbillvalue = isset($row['netbillvalue']) ? $row['netbillvalue'] : '';
        $billsbuy->discounttype = isset($row['discounttype']) ? $row['discounttype'] : '';
        $billsbuy->discountvalue = isset($row['discountvalue']) ? $row['discountvalue'] : '';
        $billsbuy->finalnetbillvalue = isset($row['finalnetbillvalue']) ? $row['finalnetbillvalue'] : '';
        $billsbuy->offline = isset($row['offline']) ? $row['offline'] : '';
        $billsbuy->uploaddate = isset($row['uploaddate']) ? $row['uploaddate'] : '';
        $billsbuy->pricetype = isset($row['pricetype']) ? $row['pricetype'] : '';
        $billsbuy->billstatus = isset($row['billstatus']) ? $row['billstatus'] : '';
        $billsbuy->approvalno = isset($row['approvalno']) ? $row['approvalno'] : '';
        $billsbuy->deliverytime = isset($row['deliverytime']) ? $row['deliverytime'] : '';
        $billsbuy->kashfplace = isset($row['kashfplace']) ? $row['kashfplace'] : '';
        $billsbuy->kashfdate = isset($row['kashfdate']) ? $row['kashfdate'] : '';
        $billsbuy->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $billsbuy->insdiscountpercent = isset($row['insdiscountpercent']) ? $row['insdiscountpercent'] : '';
        $billsbuy->clientPayReceiptVal = isset($row['clientPayReceiptVal']) ? $row['clientPayReceiptVal'] : '';
        $billsbuy->netdiscountpercent = isset($row['netdiscountpercent']) ? $row['netdiscountpercent'] : '';
        $billsbuy->rondomtxt = isset($row['rondomtxt']) ? $row['rondomtxt'] : '';
        $billsbuy->attatch = isset($row['attatch']) ? $row['attatch'] : '';
        $billsbuy->approved = isset($row['approved']) ? $row['approved'] : '';
        $billsbuy->saveid = isset($row['saveid']) ? $row['saveid'] : '';
        $billsbuy->approveNo = isset($row['approveNo']) ? $row['approveNo'] : '';
        $billsbuy->approveFile = isset($row['approveFile']) ? $row['approveFile'] : '';
        $billsbuy->notifSeen = isset($row['notifSeen']) ? $row['notifSeen'] : '';

        return $billsbuy;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BillsbuyMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>