<?php
/**
 * Class that operate on table 'buyandruternbillcurr'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-12-27 23:59
 */
class BuyandruternbillcurrMySqlDAO implements BuyandruternbillcurrDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return BuyandruternbillcurrMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM buyandruternbillcurr WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM buyandruternbillcurr';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM buyandruternbillcurr ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param buyandruternbillcurr primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM buyandruternbillcurr WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param BuyandruternbillcurrMySql buyandruternbillcurr
 	 */
	public function insert($buyandruternbillcurr){
		$sql = 'INSERT INTO buyandruternbillcurr (buybillid, conversionFactor, buybilldiscountC, buybilltotalbillC, buybillaftertotalbillC, buybilltotalpayedC, buybillfinalbillC, buybilldirectpaymentC, payedtaxC, saveConversionFactor) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($buyandruternbillcurr->buybillid);
		$sqlQuery->set($buyandruternbillcurr->conversionFactor);
		$sqlQuery->set($buyandruternbillcurr->buybilldiscountC);
		$sqlQuery->set($buyandruternbillcurr->buybilltotalbillC);
		$sqlQuery->set($buyandruternbillcurr->buybillaftertotalbillC);
		$sqlQuery->set($buyandruternbillcurr->buybilltotalpayedC);
		$sqlQuery->set($buyandruternbillcurr->buybillfinalbillC);
		$sqlQuery->setNumber($buyandruternbillcurr->buybilldirectpaymentC);
		$sqlQuery->set($buyandruternbillcurr->payedtaxC);
		$sqlQuery->set($buyandruternbillcurr->saveConversionFactor);

		$id = $this->executeInsert($sqlQuery);	
		$buyandruternbillcurr->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param BuyandruternbillcurrMySql buyandruternbillcurr
 	 */
	public function update($buyandruternbillcurr){
		$sql = 'UPDATE buyandruternbillcurr SET buybillid = ?, conversionFactor = ?, buybilldiscountC = ?, buybilltotalbillC = ?, buybillaftertotalbillC = ?, buybilltotalpayedC = ?, buybillfinalbillC = ?, buybilldirectpaymentC = ?, payedtaxC = ?, saveConversionFactor = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($buyandruternbillcurr->buybillid);
		$sqlQuery->set($buyandruternbillcurr->conversionFactor);
		$sqlQuery->set($buyandruternbillcurr->buybilldiscountC);
		$sqlQuery->set($buyandruternbillcurr->buybilltotalbillC);
		$sqlQuery->set($buyandruternbillcurr->buybillaftertotalbillC);
		$sqlQuery->set($buyandruternbillcurr->buybilltotalpayedC);
		$sqlQuery->set($buyandruternbillcurr->buybillfinalbillC);
		$sqlQuery->setNumber($buyandruternbillcurr->buybilldirectpaymentC);
		$sqlQuery->set($buyandruternbillcurr->payedtaxC);
		$sqlQuery->set($buyandruternbillcurr->saveConversionFactor);

		$sqlQuery->setNumber($buyandruternbillcurr->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM buyandruternbillcurr';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByBuybillid($value){
		$sql = 'SELECT * FROM buyandruternbillcurr WHERE buybillid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConversionFactor($value){
		$sql = 'SELECT * FROM buyandruternbillcurr WHERE conversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBuybilldiscountC($value){
		$sql = 'SELECT * FROM buyandruternbillcurr WHERE buybilldiscountC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBuybilltotalbillC($value){
		$sql = 'SELECT * FROM buyandruternbillcurr WHERE buybilltotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBuybillaftertotalbillC($value){
		$sql = 'SELECT * FROM buyandruternbillcurr WHERE buybillaftertotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBuybilltotalpayedC($value){
		$sql = 'SELECT * FROM buyandruternbillcurr WHERE buybilltotalpayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBuybillfinalbillC($value){
		$sql = 'SELECT * FROM buyandruternbillcurr WHERE buybillfinalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBuybilldirectpaymentC($value){
		$sql = 'SELECT * FROM buyandruternbillcurr WHERE buybilldirectpaymentC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPayedtaxC($value){
		$sql = 'SELECT * FROM buyandruternbillcurr WHERE payedtaxC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySaveConversionFactor($value){
		$sql = 'SELECT * FROM buyandruternbillcurr WHERE saveConversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByBuybillid($value){
		$sql = 'DELETE FROM buyandruternbillcurr WHERE buybillid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConversionFactor($value){
		$sql = 'DELETE FROM buyandruternbillcurr WHERE conversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBuybilldiscountC($value){
		$sql = 'DELETE FROM buyandruternbillcurr WHERE buybilldiscountC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBuybilltotalbillC($value){
		$sql = 'DELETE FROM buyandruternbillcurr WHERE buybilltotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBuybillaftertotalbillC($value){
		$sql = 'DELETE FROM buyandruternbillcurr WHERE buybillaftertotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBuybilltotalpayedC($value){
		$sql = 'DELETE FROM buyandruternbillcurr WHERE buybilltotalpayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBuybillfinalbillC($value){
		$sql = 'DELETE FROM buyandruternbillcurr WHERE buybillfinalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBuybilldirectpaymentC($value){
		$sql = 'DELETE FROM buyandruternbillcurr WHERE buybilldirectpaymentC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPayedtaxC($value){
		$sql = 'DELETE FROM buyandruternbillcurr WHERE payedtaxC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySaveConversionFactor($value){
		$sql = 'DELETE FROM buyandruternbillcurr WHERE saveConversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return BuyandruternbillcurrMySql 
	 */
	protected function readRow($row){
		$buyandruternbillcurr = new Buyandruternbillcurr();
		
		$buyandruternbillcurr->id = $row['id'];
		$buyandruternbillcurr->buybillid = $row['buybillid'];
		$buyandruternbillcurr->conversionFactor = $row['conversionFactor'];
		$buyandruternbillcurr->buybilldiscountC = $row['buybilldiscountC'];
		$buyandruternbillcurr->buybilltotalbillC = $row['buybilltotalbillC'];
		$buyandruternbillcurr->buybillaftertotalbillC = $row['buybillaftertotalbillC'];
		$buyandruternbillcurr->buybilltotalpayedC = $row['buybilltotalpayedC'];
		$buyandruternbillcurr->buybillfinalbillC = $row['buybillfinalbillC'];
		$buyandruternbillcurr->buybilldirectpaymentC = $row['buybilldirectpaymentC'];
		$buyandruternbillcurr->payedtaxC = $row['payedtaxC'];
		$buyandruternbillcurr->saveConversionFactor = $row['saveConversionFactor'];

		return $buyandruternbillcurr;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return BuyandruternbillcurrMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>