<?php

/**
 * Class that operate on table 'buybilldetailoffer'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2022-01-05 22:09
 */
class BuybilldetailofferMySqlDAO implements BuybilldetailofferDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BuybilldetailofferMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE buybilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM buybilldetailoffer';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM buybilldetailoffer ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param buybilldetailoffer primary key
     */
    public function delete($buybilldetailid) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE buybilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($buybilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BuybilldetailofferMySql buybilldetailoffer
     */
    public function insert($buybilldetailoffer) {
        $sql = 'INSERT INTO buybilldetailoffer (Parcode, buybillid, buybilldetailcatid, buybilldetailproductid, buybilldetailquantity, buybilldetailprice, buybilldetailtotalprice, discountvalue, note, buybilldetaildate, productunitid, lastbuyprice, meanbuyprice, lastbuyprice_withDiscount, meanbuyprice_withDiscount, otherdetailquantity, sizeid, colorid, quantitybefore, buybilldetailpriceC, buybilldetailtotalpriceC, discountvalueC, discountper, discounttype) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($buybilldetailoffer->parcode);
        $sqlQuery->setNumber($buybilldetailoffer->buybillid);
        $sqlQuery->setNumber($buybilldetailoffer->buybilldetailcatid);
        $sqlQuery->setNumber($buybilldetailoffer->buybilldetailproductid);
        $sqlQuery->set($buybilldetailoffer->buybilldetailquantity);
        $sqlQuery->set($buybilldetailoffer->buybilldetailprice);
        $sqlQuery->set($buybilldetailoffer->buybilldetailtotalprice);
        $sqlQuery->set($buybilldetailoffer->discountvalue);
        $sqlQuery->set($buybilldetailoffer->note);
        $sqlQuery->set($buybilldetailoffer->buybilldetaildate);
        $sqlQuery->setNumber($buybilldetailoffer->productunitid);
        $sqlQuery->set($buybilldetailoffer->lastbuyprice);
        $sqlQuery->set($buybilldetailoffer->meanbuyprice);
        $sqlQuery->set($buybilldetailoffer->lastbuypriceWithDiscount);
        $sqlQuery->set($buybilldetailoffer->meanbuypriceWithDiscount);
        $sqlQuery->setNumber($buybilldetailoffer->otherdetailquantity);
        $sqlQuery->setNumber($buybilldetailoffer->sizeid);
        $sqlQuery->setNumber($buybilldetailoffer->colorid);
        $sqlQuery->set($buybilldetailoffer->quantitybefore);
        $sqlQuery->set($buybilldetailoffer->buybilldetailpriceC);
        $sqlQuery->set($buybilldetailoffer->buybilldetailtotalpriceC);
        $sqlQuery->set($buybilldetailoffer->discountvalueC);
        $sqlQuery->set($buybilldetailoffer->discountper);
        $sqlQuery->set($buybilldetailoffer->discounttype);

        $id = $this->executeInsert($sqlQuery);
        $buybilldetailoffer->buybilldetailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BuybilldetailofferMySql buybilldetailoffer
     */
    public function update($buybilldetailoffer) {
        $sql = 'UPDATE buybilldetailoffer SET Parcode = ?, buybillid = ?, buybilldetailcatid = ?, buybilldetailproductid = ?, buybilldetailquantity = ?, buybilldetailprice = ?, buybilldetailtotalprice = ?, discountvalue = ?, note = ?, buybilldetaildate = ?, productunitid = ?, lastbuyprice = ?, meanbuyprice = ?, lastbuyprice_withDiscount = ?, meanbuyprice_withDiscount = ?, otherdetailquantity = ?, sizeid = ?, colorid = ?, quantitybefore = ?, buybilldetailpriceC = ?, buybilldetailtotalpriceC = ?, discountvalueC = ?, discountper = ?, discounttype = ? WHERE buybilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($buybilldetailoffer->parcode);
        $sqlQuery->setNumber($buybilldetailoffer->buybillid);
        $sqlQuery->setNumber($buybilldetailoffer->buybilldetailcatid);
        $sqlQuery->setNumber($buybilldetailoffer->buybilldetailproductid);
        $sqlQuery->set($buybilldetailoffer->buybilldetailquantity);
        $sqlQuery->set($buybilldetailoffer->buybilldetailprice);
        $sqlQuery->set($buybilldetailoffer->buybilldetailtotalprice);
        $sqlQuery->set($buybilldetailoffer->discountvalue);
        $sqlQuery->set($buybilldetailoffer->note);
        $sqlQuery->set($buybilldetailoffer->buybilldetaildate);
        $sqlQuery->setNumber($buybilldetailoffer->productunitid);
        $sqlQuery->set($buybilldetailoffer->lastbuyprice);
        $sqlQuery->set($buybilldetailoffer->meanbuyprice);
        $sqlQuery->set($buybilldetailoffer->lastbuypriceWithDiscount);
        $sqlQuery->set($buybilldetailoffer->meanbuypriceWithDiscount);
        $sqlQuery->setNumber($buybilldetailoffer->otherdetailquantity);
        $sqlQuery->setNumber($buybilldetailoffer->sizeid);
        $sqlQuery->setNumber($buybilldetailoffer->colorid);
        $sqlQuery->set($buybilldetailoffer->quantitybefore);
        $sqlQuery->set($buybilldetailoffer->buybilldetailpriceC);
        $sqlQuery->set($buybilldetailoffer->buybilldetailtotalpriceC);
        $sqlQuery->set($buybilldetailoffer->discountvalueC);
        $sqlQuery->set($buybilldetailoffer->discountper);
        $sqlQuery->set($buybilldetailoffer->discounttype);

        $sqlQuery->setNumber($buybilldetailoffer->buybilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM buybilldetailoffer';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE Parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillid($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailcatid($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE buybilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailproductid($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE buybilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailquantity($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE buybilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailprice($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE buybilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailtotalprice($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE buybilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalue($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetaildate($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE buybilldetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductunitid($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLastbuyprice($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE lastbuyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMeanbuyprice($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE meanbuyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLastbuypriceWithDiscount($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE lastbuyprice_withDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMeanbuypriceWithDiscount($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE meanbuyprice_withDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOtherdetailquantity($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE otherdetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySizeid($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByColorid($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantitybefore($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE quantitybefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailpriceC($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE buybilldetailpriceC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldetailtotalpriceC($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE buybilldetailtotalpriceC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalueC($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE discountvalueC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountper($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE discountper = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscounttype($value) {
        $sql = 'SELECT * FROM buybilldetailoffer WHERE discounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE Parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillid($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailcatid($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE buybilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailproductid($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE buybilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailquantity($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE buybilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailprice($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE buybilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailtotalprice($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE buybilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalue($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetaildate($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE buybilldetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductunitid($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLastbuyprice($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE lastbuyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMeanbuyprice($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE meanbuyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLastbuypriceWithDiscount($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE lastbuyprice_withDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMeanbuypriceWithDiscount($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE meanbuyprice_withDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOtherdetailquantity($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE otherdetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySizeid($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByColorid($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantitybefore($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE quantitybefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailpriceC($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE buybilldetailpriceC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldetailtotalpriceC($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE buybilldetailtotalpriceC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalueC($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE discountvalueC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountper($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE discountper = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscounttype($value) {
        $sql = 'DELETE FROM buybilldetailoffer WHERE discounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BuybilldetailofferMySql
     */
    protected function readRow($row) {
        $buybilldetailoffer = new Buybilldetailoffer();

        $buybilldetailoffer->parcode = $row['Parcode'];
        $buybilldetailoffer->buybilldetailid = $row['buybilldetailid'];
        $buybilldetailoffer->buybillid = $row['buybillid'];
        $buybilldetailoffer->buybilldetailcatid = $row['buybilldetailcatid'];
        $buybilldetailoffer->buybilldetailproductid = $row['buybilldetailproductid'];
        $buybilldetailoffer->buybilldetailquantity = $row['buybilldetailquantity'];
        $buybilldetailoffer->buybilldetailprice = $row['buybilldetailprice'];
        $buybilldetailoffer->buybilldetailtotalprice = $row['buybilldetailtotalprice'];
        $buybilldetailoffer->discountvalue = $row['discountvalue'];
        $buybilldetailoffer->note = $row['note'];
        $buybilldetailoffer->buybilldetaildate = $row['buybilldetaildate'];
        $buybilldetailoffer->productunitid = $row['productunitid'];
        $buybilldetailoffer->lastbuyprice = $row['lastbuyprice'];
        $buybilldetailoffer->meanbuyprice = $row['meanbuyprice'];
        $buybilldetailoffer->lastbuypriceWithDiscount = $row['lastbuyprice_withDiscount'];
        $buybilldetailoffer->meanbuypriceWithDiscount = $row['meanbuyprice_withDiscount'];
        $buybilldetailoffer->otherdetailquantity = $row['otherdetailquantity'];
        $buybilldetailoffer->sizeid = $row['sizeid'];
        $buybilldetailoffer->colorid = $row['colorid'];
        $buybilldetailoffer->quantitybefore = $row['quantitybefore'];
        $buybilldetailoffer->buybilldetailpriceC = $row['buybilldetailpriceC'];
        $buybilldetailoffer->buybilldetailtotalpriceC = $row['buybilldetailtotalpriceC'];
        $buybilldetailoffer->discountvalueC = $row['discountvalueC'];
        $buybilldetailoffer->discountper = $row['discountper'];
        $buybilldetailoffer->discounttype = $row['discounttype'];
        //
        $buybilldetailoffer->productName = $row['productName'];
        $buybilldetailoffer->unitName = $row['unitName'];
        $buybilldetailoffer->unitid = $row['unitid'];
        $buybilldetailoffer->productnumber = $row['productnumber'];
        $buybilldetailoffer->productCatName = $row['productCatName'];
        $buybilldetailoffer->sizeName = $row['sizeName'];
        $buybilldetailoffer->colorName = $row['colorName'];

        return $buybilldetailoffer;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BuybilldetailofferMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>