<?php

/**
 * Class that operate on table 'dailyentrycreditor'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-04-18 15:43
 */
class DailyentrycreditorMySqlDAO implements DailyentrycreditorDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return DailyentrycreditorMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM dailyentrycreditor WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM dailyentrycreditor';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM dailyentrycreditor ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param dailyentrycreditor primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM dailyentrycreditor WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param DailyentrycreditorMySql dailyentrycreditor
     */
    public function insert($dailyentrycreditor) {
        $sql = 'INSERT INTO dailyentrycreditor (dailyentryid, accountstreeid, value, dComment,costcenterid) VALUES (?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($dailyentrycreditor->dailyentryid);
        $sqlQuery->setNumber($dailyentrycreditor->accountstreeid);
        $sqlQuery->set($dailyentrycreditor->value);
        $sqlQuery->set($dailyentrycreditor->dComment);
        $sqlQuery->setNumber($dailyentrycreditor->costcenterid);

        $id = $this->executeInsert($sqlQuery);
        $dailyentrycreditor->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param DailyentrycreditorMySql dailyentrycreditor
     */
    public function update($dailyentrycreditor) {
        $sql = 'UPDATE dailyentrycreditor SET dailyentryid = ?, accountstreeid = ?, value = ?, dComment = ?,costcenterid=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($dailyentrycreditor->dailyentryid);
        $sqlQuery->setNumber($dailyentrycreditor->accountstreeid);
        $sqlQuery->set($dailyentrycreditor->value);
        $sqlQuery->set($dailyentrycreditor->dComment);
        $sqlQuery->setNumber($dailyentrycreditor->costcenterid);

        $sqlQuery->setNumber($dailyentrycreditor->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM dailyentrycreditor';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByDailyentryid($value) {
        $sql = 'SELECT * FROM dailyentrycreditor WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountstreeid($value) {
        $sql = 'SELECT * FROM dailyentrycreditor WHERE accountstreeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByValue($value) {
        $sql = 'SELECT * FROM dailyentrycreditor WHERE value = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDComment($value) {
        $sql = 'SELECT * FROM dailyentrycreditor WHERE dComment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByDailyentryid($value) {
        $sql = 'DELETE FROM dailyentrycreditor WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountstreeid($value) {
        $sql = 'DELETE FROM dailyentrycreditor WHERE accountstreeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByValue($value) {
        $sql = 'DELETE FROM dailyentrycreditor WHERE value = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDComment($value) {
        $sql = 'DELETE FROM dailyentrycreditor WHERE dComment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return DailyentrycreditorMySql
     */
    protected function readRow($row) {
        $dailyentrycreditor = new Dailyentrycreditor();

        $dailyentrycreditor->id = isset($row['id']) ? $row['id'] : '';
        $dailyentrycreditor->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $dailyentrycreditor->accountstreeid = isset($row['accountstreeid']) ? $row['accountstreeid'] : '';
        $dailyentrycreditor->value = isset($row['value']) ? $row['value'] : '';
        $dailyentrycreditor->dComment = isset($row['dComment']) ? $row['dComment'] : '';
        $dailyentrycreditor->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';
        //
        $dailyentrycreditor->pluginComment = isset($row['pluginComment']) ? $row['pluginComment'] : '';
        $dailyentrycreditor->pluginControllerName = isset($row['pluginControllerName']) ? $row['pluginControllerName'] : '';
        $dailyentrycreditor->costcenterType = isset($row['costcenterType']) ? $row['costcenterType'] : '';

        return $dailyentrycreditor;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return DailyentrycreditorMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>