<?php

/**
 * Class that operate on table 'dailyentrydebtor'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-04-18 15:43
 */
class DailyentrydebtorMySqlDAO implements DailyentrydebtorDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return DailyentrydebtorMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM dailyentrydebtor WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM dailyentrydebtor';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM dailyentrydebtor ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param dailyentrydebtor primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM dailyentrydebtor WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param DailyentrydebtorMySql dailyentrydebtor
     */
    public function insert($dailyentrydebtor) {
        $sql = 'INSERT INTO dailyentrydebtor (dailyentryid, accountstreeid, value, dComment,costcenterid) VALUES (?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($dailyentrydebtor->dailyentryid);
        $sqlQuery->setNumber($dailyentrydebtor->accountstreeid);
        $sqlQuery->set($dailyentrydebtor->value);
        $sqlQuery->set($dailyentrydebtor->dComment);
        $sqlQuery->setNumber($dailyentrydebtor->costcenterid);

        $id = $this->executeInsert($sqlQuery);
        $dailyentrydebtor->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param DailyentrydebtorMySql dailyentrydebtor
     */
    public function update($dailyentrydebtor) {
        $sql = 'UPDATE dailyentrydebtor SET dailyentryid = ?, accountstreeid = ?, value = ?, dComment = ?,costcenterid=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($dailyentrydebtor->dailyentryid);
        $sqlQuery->setNumber($dailyentrydebtor->accountstreeid);
        $sqlQuery->set($dailyentrydebtor->value);
        $sqlQuery->set($dailyentrydebtor->dComment);
        $sqlQuery->setNumber($dailyentrydebtor->costcenterid);

        $sqlQuery->setNumber($dailyentrydebtor->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM dailyentrydebtor';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByDailyentryid($value) {
        $sql = 'SELECT * FROM dailyentrydebtor WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountstreeid($value) {
        $sql = 'SELECT * FROM dailyentrydebtor WHERE accountstreeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByValue($value) {
        $sql = 'SELECT * FROM dailyentrydebtor WHERE value = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDComment($value) {
        $sql = 'SELECT * FROM dailyentrydebtor WHERE dComment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByDailyentryid($value) {
        $sql = 'DELETE FROM dailyentrydebtor WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountstreeid($value) {
        $sql = 'DELETE FROM dailyentrydebtor WHERE accountstreeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByValue($value) {
        $sql = 'DELETE FROM dailyentrydebtor WHERE value = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDComment($value) {
        $sql = 'DELETE FROM dailyentrydebtor WHERE dComment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return DailyentrydebtorMySql
     */
    protected function readRow($row) {
        $dailyentrydebtor = new Dailyentrydebtor();

        $dailyentrydebtor->id = isset($row['id']) ? $row['id'] : '';
        $dailyentrydebtor->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $dailyentrydebtor->accountstreeid = isset($row['accountstreeid']) ? $row['accountstreeid'] : '';
        $dailyentrydebtor->value = isset($row['value']) ? $row['value'] : '';
        $dailyentrydebtor->dComment = isset($row['dComment']) ? $row['dComment'] : '';
        $dailyentrydebtor->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';
        //
        $dailyentrydebtor->pluginComment = isset($row['pluginComment']) ? $row['pluginComment'] : '';
        $dailyentrydebtor->pluginControllerName = isset($row['pluginControllerName']) ? $row['pluginControllerName'] : '';
        $dailyentrydebtor->costcenterType = isset($row['costcenterType']) ? $row['costcenterType'] : '';
        return $dailyentrydebtor;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return DailyentrydebtorMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>