<?php

/**
 * Class that operate on table 'employeesubgroup'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-11-11 22:24
 */
class EmployeesubgroupMySqlDAO implements EmployeesubgroupDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return EmployeesubgroupMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM employeesubgroup WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM employeesubgroup';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM employeesubgroup ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param employeesubgroup primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM employeesubgroup WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param EmployeesubgroupMySql employeesubgroup
     */
    public function insert($employeesubgroup) {
        $sql = 'INSERT INTO employeesubgroup (name, employeegroupid, employeeattendancesystemid, userid, del, sysdate) VALUES (?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($employeesubgroup->name);
        $sqlQuery->setNumber($employeesubgroup->employeegroupid);
        $sqlQuery->setNumber($employeesubgroup->employeeattendancesystemid);
        $sqlQuery->setNumber($employeesubgroup->userid);
        $sqlQuery->setNumber($employeesubgroup->del);
        $sqlQuery->set($employeesubgroup->sysdate);

        $id = $this->executeInsert($sqlQuery);
        $employeesubgroup->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param EmployeesubgroupMySql employeesubgroup
     */
    public function update($employeesubgroup) {
        $sql = 'UPDATE employeesubgroup SET name = ?, employeegroupid = ?, employeeattendancesystemid = ?, userid = ?, del = ?, sysdate = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($employeesubgroup->name);
        $sqlQuery->setNumber($employeesubgroup->employeegroupid);
        $sqlQuery->setNumber($employeesubgroup->employeeattendancesystemid);
        $sqlQuery->setNumber($employeesubgroup->userid);
        $sqlQuery->setNumber($employeesubgroup->del);
        $sqlQuery->set($employeesubgroup->sysdate);

        $sqlQuery->setNumber($employeesubgroup->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM employeesubgroup';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM employeesubgroup WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeegroupid($value) {
        $sql = 'SELECT * FROM employeesubgroup WHERE employeegroupid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeeattendancesystemid($value) {
        $sql = 'SELECT * FROM employeesubgroup WHERE employeeattendancesystemid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM employeesubgroup WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM employeesubgroup WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM employeesubgroup WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM employeesubgroup WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeegroupid($value) {
        $sql = 'DELETE FROM employeesubgroup WHERE employeegroupid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeeattendancesystemid($value) {
        $sql = 'DELETE FROM employeesubgroup WHERE employeeattendancesystemid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM employeesubgroup WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM employeesubgroup WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM employeesubgroup WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return EmployeesubgroupMySql
     */
    protected function readRow($row) {
        $employeesubgroup = new Employeesubgroup();

        $employeesubgroup->id = $row['id'];
        $employeesubgroup->name = $row['name'];
        $employeesubgroup->employeegroupid = $row['employeegroupid'];
        $employeesubgroup->employeeattendancesystemid = $row['employeeattendancesystemid'];
        $employeesubgroup->userid = $row['userid'];
        $employeesubgroup->del = $row['del'];
        $employeesubgroup->sysdate = $row['sysdate'];
        //
        $employeesubgroup->status = $row['status'];

        return $employeesubgroup;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return EmployeesubgroupMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>