<?php

/**
 * Class that operate on table 'expenseexchange'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-07-04 11:25
 */
class ExpenseexchangeMySqlDAO implements ExpenseexchangeDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ExpenseexchangeMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM expenseexchange WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM expenseexchange';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM expenseexchange ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param expenseexchange primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM expenseexchange WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ExpenseexchangeMySql expenseexchange
     */
    public function insert($expenseexchange) {
        $sql = 'INSERT INTO expenseexchange (serialno, projectid, expensefrom, expenseid, expenseid2, thevalue, costcenterid, expensedate, expensetype, userid, del, sysdate, entryid, expenseexcomment) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($expenseexchange->serialno);
        $sqlQuery->setNumber($expenseexchange->projectid);
        $sqlQuery->setNumber($expenseexchange->expensefrom);
        $sqlQuery->setNumber($expenseexchange->expenseid);
        $sqlQuery->setNumber($expenseexchange->expenseid2);
        $sqlQuery->setNumber($expenseexchange->thevalue);
        $sqlQuery->setNumber($expenseexchange->costcenterid);
        $sqlQuery->set($expenseexchange->expensedate);
        $sqlQuery->setNumber($expenseexchange->expensetype);
        $sqlQuery->setNumber($expenseexchange->userid);
        $sqlQuery->setNumber($expenseexchange->del);
        $sqlQuery->set($expenseexchange->sysdate);
        $sqlQuery->setNumber($expenseexchange->entryid);
        $sqlQuery->set($expenseexchange->expenseexcomment);

        $id = $this->executeInsert($sqlQuery);
        $expenseexchange->id = $id;

        return $id;
    }

    /**
     * Update record in table
     *
     * @param ExpenseexchangeMySql expenseexchange
     */
    public function update($expenseexchange) {
        $sql = 'UPDATE expenseexchange SET serialno = ?, projectid = ?, expensefrom = ?, expenseid = ?, expenseid2 = ?, thevalue = ?, costcenterid = ?, expensedate = ?, expensetype = ?, userid = ?, del = ?, sysdate = ?, entryid = ?, expenseexcomment = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($expenseexchange->serialno);
        $sqlQuery->setNumber($expenseexchange->projectid);
        $sqlQuery->setNumber($expenseexchange->expensefrom);
        $sqlQuery->setNumber($expenseexchange->expenseid);
        $sqlQuery->setNumber($expenseexchange->expenseid2);
        $sqlQuery->setNumber($expenseexchange->thevalue);
        $sqlQuery->setNumber($expenseexchange->costcenterid);
        $sqlQuery->set($expenseexchange->expensedate);
        $sqlQuery->setNumber($expenseexchange->expensetype);
        $sqlQuery->setNumber($expenseexchange->userid);
        $sqlQuery->setNumber($expenseexchange->del);
        $sqlQuery->set($expenseexchange->sysdate);
        $sqlQuery->setNumber($expenseexchange->entryid);
        $sqlQuery->set($expenseexchange->expenseexcomment);

        $sqlQuery->setNumber($expenseexchange->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM expenseexchange';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySerialno($value) {
        $sql = 'SELECT * FROM expenseexchange WHERE serialno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProjectid($value) {
        $sql = 'SELECT * FROM expenseexchange WHERE projectid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExpensefrom($value) {
        $sql = 'SELECT * FROM expenseexchange WHERE expensefrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExpenseid($value) {
        $sql = 'SELECT * FROM expenseexchange WHERE expenseid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExpenseid2($value) {
        $sql = 'SELECT * FROM expenseexchange WHERE expenseid2 = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByThevalue($value) {
        $sql = 'SELECT * FROM expenseexchange WHERE thevalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCostcenterid($value) {
        $sql = 'SELECT * FROM expenseexchange WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExpensedate($value) {
        $sql = 'SELECT * FROM expenseexchange WHERE expensedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExpensetype($value) {
        $sql = 'SELECT * FROM expenseexchange WHERE expensetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM expenseexchange WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM expenseexchange WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM expenseexchange WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEntryid($value) {
        $sql = 'SELECT * FROM expenseexchange WHERE entryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySerialno($value) {
        $sql = 'DELETE FROM expenseexchange WHERE serialno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProjectid($value) {
        $sql = 'DELETE FROM expenseexchange WHERE projectid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExpensefrom($value) {
        $sql = 'DELETE FROM expenseexchange WHERE expensefrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExpenseid($value) {
        $sql = 'DELETE FROM expenseexchange WHERE expenseid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExpenseid2($value) {
        $sql = 'DELETE FROM expenseexchange WHERE expenseid2 = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByThevalue($value) {
        $sql = 'DELETE FROM expenseexchange WHERE thevalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCostcenterid($value) {
        $sql = 'DELETE FROM expenseexchange WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExpensedate($value) {
        $sql = 'DELETE FROM expenseexchange WHERE expensedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExpensetype($value) {
        $sql = 'DELETE FROM expenseexchange WHERE expensetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM expenseexchange WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM expenseexchange WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM expenseexchange WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEntryid($value) {
        $sql = 'DELETE FROM expenseexchange WHERE entryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ExpenseexchangeMySql
     */
    protected function readRow($row) {
        $expenseexchange = new Expenseexchange();

        $expenseexchange->id = isset($row['id']) ? $row['id'] : '';
        $expenseexchange->serialno = isset($row['serialno']) ? $row['serialno'] : '';
        $expenseexchange->projectid = isset($row['projectid']) ? $row['projectid'] : '';
        $expenseexchange->expensefrom = isset($row['expensefrom']) ? $row['expensefrom'] : '';
        $expenseexchange->expenseid = isset($row['expenseid']) ? $row['expenseid'] : '';
        $expenseexchange->expenseid2 = isset($row['expenseid2']) ? $row['expenseid2'] : '';
        $expenseexchange->thevalue = isset($row['thevalue']) ? $row['thevalue'] : '';
        $expenseexchange->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';
        $expenseexchange->expensedate = isset($row['expensedate']) ? $row['expensedate'] : '';
        $expenseexchange->expensetype = isset($row['expensetype']) ? $row['expensetype'] : '';
        $expenseexchange->userid = isset($row['userid']) ? $row['userid'] : '';
        $expenseexchange->del = isset($row['del']) ? $row['del'] : '';
        $expenseexchange->sysdate = isset($row['sysdate']) ? $row['sysdate'] : '';
        $expenseexchange->entryid = isset($row['entryid']) ? $row['entryid'] : '';
        $expenseexchange->expenseexcomment = isset($row['expenseexcomment']) ? $row['expenseexcomment'] : '';


        return $expenseexchange;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ExpenseexchangeMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>