<?php
/**
 * Class that operate on table 'faidadirector'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-12-08 17:01
 */
class FaidadirectorMySqlDAO implements FaidadirectorDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return FaidadirectorMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM faidadirector WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM faidadirector';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM faidadirector ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param faidadirector primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM faidadirector WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param FaidadirectorMySql faidadirector
 	 */
	public function insert($faidadirector){
		$sql = 'INSERT INTO faidadirector (faida_id, conditions, comment) VALUES (?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($faidadirector->faidaId);
		$sqlQuery->setNumber($faidadirector->conditions);
		$sqlQuery->setString2($faidadirector->comment);

		$id = $this->executeInsert($sqlQuery);	
		$faidadirector->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param FaidadirectorMySql faidadirector
 	 */
	public function update($faidadirector){
		$sql = 'UPDATE faidadirector SET faida_id = ?, conditions = ?, comment = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($faidadirector->faidaId);
		$sqlQuery->setNumber($faidadirector->conditions);
		$sqlQuery->setString2($faidadirector->comment);

		$sqlQuery->setNumber($faidadirector->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM faidadirector';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByFaidaId($value){
		$sql = 'SELECT * FROM faidadirector WHERE faida_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM faidadirector WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByComment($value){
		$sql = 'SELECT * FROM faidadirector WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByFaidaId($value){
		$sql = 'DELETE FROM faidadirector WHERE faida_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM faidadirector WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByComment($value){
		$sql = 'DELETE FROM faidadirector WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return FaidadirectorMySql 
	 */
	protected function readRow($row){
		$faidadirector = new Faidadirector();
		
		$faidadirector->id = $row['id'];
		$faidadirector->faidaId = $row['faida_id'];
		$faidadirector->conditions = $row['conditions'];
		$faidadirector->comment = $row['comment'];

		return $faidadirector;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return FaidadirectorMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>