<?php

/**
 * Class that operate on table 'impotencetreatmentsuppliersave'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-09-05 06:04
 */
class ImpotencetreatmentsuppliersaveMySqlDAO implements ImpotencetreatmentsuppliersaveDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ImpotencetreatmentsuppliersaveMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave WHERE impotencetreatmentsuppliersaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param impotencetreatmentsuppliersave primary key
     */
    public function delete($impotencetreatmentsuppliersaveid) {
        $sql = 'DELETE FROM impotencetreatmentsuppliersave WHERE impotencetreatmentsuppliersaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($impotencetreatmentsuppliersaveid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ImpotencetreatmentsuppliersaveMySql impotencetreatmentsuppliersave
     */
    public function insert($impotencetreatmentsuppliersave) {
        $sql = 'INSERT INTO impotencetreatmentsuppliersave (typesimpotencetreatmentid, saveid, supplierid, impotencetreatmentsuppliersavetype, impotencetreatmentsuppliersavebefore, impotencetreatmentsuppliersavetamount, impotencetreatmentsuppliersaveafter, impotencetreatmentsuppliersavecomment, conditions, impotencetreatmentsuppliersavedate, userid, tablename,dailyentryid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($impotencetreatmentsuppliersave->typesimpotencetreatmentid);
        $sqlQuery->setNumber($impotencetreatmentsuppliersave->saveid);
        $sqlQuery->setNumber($impotencetreatmentsuppliersave->supplierid);
        $sqlQuery->setNumber($impotencetreatmentsuppliersave->impotencetreatmentsuppliersavetype);
        $sqlQuery->set($impotencetreatmentsuppliersave->impotencetreatmentsuppliersavebefore);
        $sqlQuery->set($impotencetreatmentsuppliersave->impotencetreatmentsuppliersavetamount);
        $sqlQuery->set($impotencetreatmentsuppliersave->impotencetreatmentsuppliersaveafter);
        $sqlQuery->setString2($impotencetreatmentsuppliersave->impotencetreatmentsuppliersavecomment);
        $sqlQuery->setNumber($impotencetreatmentsuppliersave->conditions);
        $sqlQuery->set($impotencetreatmentsuppliersave->impotencetreatmentsuppliersavedate);
        $sqlQuery->setNumber($impotencetreatmentsuppliersave->userid);
        $sqlQuery->set($impotencetreatmentsuppliersave->tablename);
        $sqlQuery->setNumber((int) $impotencetreatmentsuppliersave->dailyentryid);

        $id = $this->executeInsert($sqlQuery);
        $impotencetreatmentsuppliersave->impotencetreatmentsuppliersaveid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ImpotencetreatmentsuppliersaveMySql impotencetreatmentsuppliersave
     */
    public function update($impotencetreatmentsuppliersave) {
        $sql = 'UPDATE impotencetreatmentsuppliersave SET typesimpotencetreatmentid = ?, saveid = ?, supplierid = ?, impotencetreatmentsuppliersavetype = ?, impotencetreatmentsuppliersavebefore = ?, impotencetreatmentsuppliersavetamount = ?, impotencetreatmentsuppliersaveafter = ?, impotencetreatmentsuppliersavecomment = ?, conditions = ?, impotencetreatmentsuppliersavedate = ?, userid = ?, tablename = ?,dailyentryid=? WHERE impotencetreatmentsuppliersaveid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($impotencetreatmentsuppliersave->typesimpotencetreatmentid);
        $sqlQuery->setNumber($impotencetreatmentsuppliersave->saveid);
        $sqlQuery->setNumber($impotencetreatmentsuppliersave->supplierid);
        $sqlQuery->setNumber($impotencetreatmentsuppliersave->impotencetreatmentsuppliersavetype);
        $sqlQuery->set($impotencetreatmentsuppliersave->impotencetreatmentsuppliersavebefore);
        $sqlQuery->set($impotencetreatmentsuppliersave->impotencetreatmentsuppliersavetamount);
        $sqlQuery->set($impotencetreatmentsuppliersave->impotencetreatmentsuppliersaveafter);
        $sqlQuery->setString2($impotencetreatmentsuppliersave->impotencetreatmentsuppliersavecomment);
        $sqlQuery->setNumber($impotencetreatmentsuppliersave->conditions);
        $sqlQuery->set($impotencetreatmentsuppliersave->impotencetreatmentsuppliersavedate);
        $sqlQuery->setNumber($impotencetreatmentsuppliersave->userid);
        $sqlQuery->set($impotencetreatmentsuppliersave->tablename);
        $sqlQuery->setNumber((int) $impotencetreatmentsuppliersave->dailyentryid);

        $sqlQuery->setNumber($impotencetreatmentsuppliersave->impotencetreatmentsuppliersaveid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM impotencetreatmentsuppliersave';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByTypesimpotencetreatmentid($value) {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave WHERE typesimpotencetreatmentid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveid($value) {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierid($value) {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByImpotencetreatmentsuppliersavetype($value) {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave WHERE impotencetreatmentsuppliersavetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByImpotencetreatmentsuppliersavebefore($value) {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave WHERE impotencetreatmentsuppliersavebefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByImpotencetreatmentsuppliersavetamount($value) {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave WHERE impotencetreatmentsuppliersavetamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByImpotencetreatmentsuppliersaveafter($value) {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave WHERE impotencetreatmentsuppliersaveafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByImpotencetreatmentsuppliersavecomment($value) {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave WHERE impotencetreatmentsuppliersavecomment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByImpotencetreatmentsuppliersavedate($value) {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave WHERE impotencetreatmentsuppliersavedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTablename($value) {
        $sql = 'SELECT * FROM impotencetreatmentsuppliersave WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByTypesimpotencetreatmentid($value) {
        $sql = 'DELETE FROM impotencetreatmentsuppliersave WHERE typesimpotencetreatmentid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveid($value) {
        $sql = 'DELETE FROM impotencetreatmentsuppliersave WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierid($value) {
        $sql = 'DELETE FROM impotencetreatmentsuppliersave WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByImpotencetreatmentsuppliersavetype($value) {
        $sql = 'DELETE FROM impotencetreatmentsuppliersave WHERE impotencetreatmentsuppliersavetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByImpotencetreatmentsuppliersavebefore($value) {
        $sql = 'DELETE FROM impotencetreatmentsuppliersave WHERE impotencetreatmentsuppliersavebefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByImpotencetreatmentsuppliersavetamount($value) {
        $sql = 'DELETE FROM impotencetreatmentsuppliersave WHERE impotencetreatmentsuppliersavetamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByImpotencetreatmentsuppliersaveafter($value) {
        $sql = 'DELETE FROM impotencetreatmentsuppliersave WHERE impotencetreatmentsuppliersaveafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByImpotencetreatmentsuppliersavecomment($value) {
        $sql = 'DELETE FROM impotencetreatmentsuppliersave WHERE impotencetreatmentsuppliersavecomment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM impotencetreatmentsuppliersave WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByImpotencetreatmentsuppliersavedate($value) {
        $sql = 'DELETE FROM impotencetreatmentsuppliersave WHERE impotencetreatmentsuppliersavedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM impotencetreatmentsuppliersave WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTablename($value) {
        $sql = 'DELETE FROM impotencetreatmentsuppliersave WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ImpotencetreatmentsuppliersaveMySql
     */
    protected function readRow($row) {
        $impotencetreatmentsuppliersave = new Impotencetreatmentsuppliersave();

        $impotencetreatmentsuppliersave->impotencetreatmentsuppliersaveid = $row['impotencetreatmentsuppliersaveid'];
        $impotencetreatmentsuppliersave->typesimpotencetreatmentid = $row['typesimpotencetreatmentid'];
        $impotencetreatmentsuppliersave->saveid = $row['saveid'];
        $impotencetreatmentsuppliersave->supplierid = $row['supplierid'];
        $impotencetreatmentsuppliersave->impotencetreatmentsuppliersavetype = $row['impotencetreatmentsuppliersavetype'];
        $impotencetreatmentsuppliersave->impotencetreatmentsuppliersavebefore = $row['impotencetreatmentsuppliersavebefore'];
        $impotencetreatmentsuppliersave->impotencetreatmentsuppliersavetamount = $row['impotencetreatmentsuppliersavetamount'];
        $impotencetreatmentsuppliersave->impotencetreatmentsuppliersaveafter = $row['impotencetreatmentsuppliersaveafter'];
        $impotencetreatmentsuppliersave->impotencetreatmentsuppliersavecomment = $row['impotencetreatmentsuppliersavecomment'];
        $impotencetreatmentsuppliersave->conditions = $row['conditions'];
        $impotencetreatmentsuppliersave->impotencetreatmentsuppliersavedate = $row['impotencetreatmentsuppliersavedate'];
        $impotencetreatmentsuppliersave->userid = $row['userid'];
        $impotencetreatmentsuppliersave->tablename = $row['tablename'];
        $impotencetreatmentsuppliersave->dailyentryid = $row['dailyentryid'];

        return $impotencetreatmentsuppliersave;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ImpotencetreatmentsuppliersaveMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>