<?php

/**
 * Class that operate on table 'income'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-07-19 10:51
 */
class IncomeMySqlDAO implements IncomeDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return IncomeMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM income WHERE incomeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM income';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM income ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param income primary key
     */
    public function delete($incomeId) {
        $sql = 'DELETE FROM income WHERE incomeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($incomeId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param IncomeMySql income
     */
    public function insert($income) {
        $sql = 'INSERT INTO income (incomeTypeId, incomeName, incomeDetails, incomeValue, incomeDate, userid, conditions,costcenterid,dailyentryid,saveid,clientid) VALUES (?, ?, ?, ?, ?, ?, ?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($income->incomeTypeId);
        $sqlQuery->set($income->incomeName);
        $sqlQuery->setString2($income->incomeDetails);
        $sqlQuery->set($income->incomeValue);
        $sqlQuery->set($income->incomeDate);
        $sqlQuery->setNumber($income->userid);
        $sqlQuery->setNumber($income->conditions);
        $sqlQuery->setNumber($income->costcenterid);
        $sqlQuery->setNumber($income->dailyentryid);
        $sqlQuery->setNumber($income->saveid);
        $sqlQuery->set($income->clientid);



        $id = $this->executeInsert($sqlQuery);
        $income->incomeId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param IncomeMySql income
     */
    public function update($income) {
        $sql = 'UPDATE income SET incomeTypeId = ?, incomeName = ?, incomeDetails = ?, incomeValue = ?, incomeDate = ?, userid = ?, conditions = ? , dailyentryid= ?, saveid = ?, clientid = ? WHERE incomeId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($income->incomeTypeId);
        $sqlQuery->set($income->incomeName);
        $sqlQuery->setString2($income->incomeDetails);
        $sqlQuery->set($income->incomeValue);
        $sqlQuery->set($income->incomeDate);
        $sqlQuery->setNumber($income->userid);
        $sqlQuery->setNumber($income->conditions);
        $sqlQuery->setNumber($income->dailyentryid);
        $sqlQuery->setNumber($income->saveid);
        $sqlQuery->set($income->clientid);


        $sqlQuery->setNumber($income->incomeId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM income';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByIncomeTypeId($value) {
        $sql = 'SELECT * FROM income WHERE incomeTypeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIncomeName($value) {
        $sql = 'SELECT * FROM income WHERE incomeName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIncomeDetails($value) {
        $sql = 'SELECT * FROM income WHERE incomeDetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIncomeValue($value) {
        $sql = 'SELECT * FROM income WHERE incomeValue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIncomeDate($value) {
        $sql = 'SELECT * FROM income WHERE incomeDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM income WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM income WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByIncomeTypeId($value) {
        $sql = 'DELETE FROM income WHERE incomeTypeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIncomeName($value) {
        $sql = 'DELETE FROM income WHERE incomeName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIncomeDetails($value) {
        $sql = 'DELETE FROM income WHERE incomeDetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIncomeValue($value) {
        $sql = 'DELETE FROM income WHERE incomeValue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIncomeDate($value) {
        $sql = 'DELETE FROM income WHERE incomeDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM income WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM income WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return IncomeMySql
     */
    protected function readRow($row) {
        $income = new Income();

        $income->incomeId = isset($row['incomeId']) ? $row['incomeId'] : '';
        $income->incomeTypeId = isset($row['incomeTypeId']) ? $row['incomeTypeId'] : '';
        $income->incomeName = isset($row['incomeName']) ? $row['incomeName'] : '';
        $income->incomeDetails = isset($row['incomeDetails']) ? $row['incomeDetails'] : '';
        $income->incomeValue = isset($row['incomeValue']) ? $row['incomeValue'] : '';
        $income->incomeDate = isset($row['incomeDate']) ? $row['incomeDate'] : '';
        $income->userid = isset($row['userid']) ? $row['userid'] : '';
        $income->conditions = isset($row['conditions']) ? $row['conditions'] : '';

        $income->incomeTypeName = isset($row['incomeTypeName']) ? $row['incomeTypeName'] : '';
        $income->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';
        $income->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $income->saveid = isset($row['saveid']) ? $row['saveid'] : '';
        $income->savename = isset($row['savename']) ? $row['savename'] : '';
        $income->clientid = isset($row['clientid']) ? $row['clientid'] : '';




        return $income;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return IncomeMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>