<?php

/**
 * Class that operate on table 'm_stageproperity'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MStageproperityMySqlDAO implements MStageproperityDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MStageproperityMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_stageproperity WHERE stageProperityId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_stageproperity';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_stageproperity ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mStageproperity primary key
     */
    public function delete($stageProperityId) {
        $sql = 'DELETE FROM m_stageproperity WHERE stageProperityId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($stageProperityId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MStageproperityMySql mStageproperity
     */
    public function insert($mStageproperity) {
        $sql = 'INSERT INTO m_stageproperity (name, initialValue, stageId, userId, branchId, stageProperityDate, del) VALUES (?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mStageproperity->name);
        $sqlQuery->set($mStageproperity->initialValue);
        $sqlQuery->setNumber($mStageproperity->stageId);
        $sqlQuery->setNumber($mStageproperity->userId);
        $sqlQuery->setNumber($mStageproperity->branchId);
        $sqlQuery->set($mStageproperity->stageProperityDate);
        $sqlQuery->setNumber($mStageproperity->del);

        $id = $this->executeInsert($sqlQuery);
        $mStageproperity->stageProperityId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MStageproperityMySql mStageproperity
     */
    public function update($mStageproperity) {
        $sql = 'UPDATE m_stageproperity SET name = ?, initialValue = ?, stageId = ?, userId = ?, branchId = ?, stageProperityDate = ?, del = ? WHERE stageProperityId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mStageproperity->name);
        $sqlQuery->set($mStageproperity->initialValue);
        $sqlQuery->setNumber($mStageproperity->stageId);
        $sqlQuery->setNumber($mStageproperity->userId);
        $sqlQuery->setNumber($mStageproperity->branchId);
        $sqlQuery->set($mStageproperity->stageProperityDate);
        $sqlQuery->setNumber($mStageproperity->del);

        $sqlQuery->setNumber($mStageproperity->stageProperityId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_stageproperity';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM m_stageproperity WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInitialValue($value) {
        $sql = 'SELECT * FROM m_stageproperity WHERE initialValue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStageId($value) {
        $sql = 'SELECT *
		FROM m_stageproperity
		WHERE stageId = ?
		AND del =0 ';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM m_stageproperity WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchId($value) {
        $sql = 'SELECT * FROM m_stageproperity WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStageProperityDate($value) {
        $sql = 'SELECT * FROM m_stageproperity WHERE stageProperityDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM m_stageproperity WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM m_stageproperity WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInitialValue($value) {
        $sql = 'DELETE FROM m_stageproperity WHERE initialValue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStageId($value) {
        $sql = 'DELETE FROM m_stageproperity WHERE stageId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM m_stageproperity WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchId($value) {
        $sql = 'DELETE FROM m_stageproperity WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStageProperityDate($value) {
        $sql = 'DELETE FROM m_stageproperity WHERE stageProperityDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM m_stageproperity WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MStageproperityMySql
     */
    protected function readRow($row) {
        $mStageproperity = new MStageproperity();

        $mStageproperity->stageProperityId = isset($row['stageProperityId']) ? $row['stageProperityId'] : '';
        $mStageproperity->name = isset($row['name']) ? $row['name'] : '';
        $mStageproperity->initialValue = isset($row['initialValue']) ? $row['initialValue'] : '';
        $mStageproperity->stageId = isset($row['stageId']) ? $row['stageId'] : '';
        $mStageproperity->userId = isset($row['userId']) ? $row['userId'] : '';
        $mStageproperity->branchId = isset($row['branchId']) ? $row['branchId'] : '';
        $mStageproperity->stageProperityDate = isset($row['stageProperityDate']) ? $row['stageProperityDate'] : '';
        $mStageproperity->del = isset($row['del']) ? $row['del'] : '';
        $mStageproperity->title = isset($row['title']) ? $row['title'] : '';


        return $mStageproperity;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MStageproperityMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>