<?php

/**
 * Class that operate on table 'measurementunits'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
class MeasurementunitsMySqlDAO implements MeasurementunitsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MeasurementunitsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM measurementunits WHERE measurementunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM measurementunits';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM measurementunits ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param measurementunit primary key
     */
    public function delete($measurementunitid) {
        $sql = 'DELETE FROM measurementunits WHERE measurementunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($measurementunitid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MeasurementunitsMySql measurementunit
     */
    public function insert($measurementunit) {
        $sql = 'INSERT INTO measurementunits (measurementunitname, measurementunitdescription, tempdelete, currentdate) VALUES (?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($measurementunit->measurementunitname);
        $sqlQuery->set($measurementunit->measurementunitdescription);
        $sqlQuery->setNumber($measurementunit->tempdelete);
        $sqlQuery->set($measurementunit->currentdate);

        $id = $this->executeInsert($sqlQuery);
        $measurementunit->measurementunitid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MeasurementunitsMySql measurementunit
     */
    public function update($measurementunit) {
        $sql = 'UPDATE measurementunits SET measurementunitname = ?, measurementunitdescription = ?, tempdelete = ?, currentdate = ? WHERE measurementunitid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($measurementunit->measurementunitname);
        $sqlQuery->set($measurementunit->measurementunitdescription);
        $sqlQuery->setNumber($measurementunit->tempdelete);
        $sqlQuery->set($measurementunit->currentdate);

        $sqlQuery->setNumber($measurementunit->measurementunitid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM measurementunits';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByMeasurementunitname($value) {
        $sql = 'SELECT * FROM measurementunits WHERE measurementunitname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMeasurementunitdescription($value) {
        $sql = 'SELECT * FROM measurementunits WHERE measurementunitdescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempdelete($value) {
        $sql = 'SELECT * FROM measurementunits WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrentdate($value) {
        $sql = 'SELECT * FROM measurementunits WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByMeasurementunitname($value) {
        $sql = 'DELETE FROM measurementunits WHERE measurementunitname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMeasurementunitdescription($value) {
        $sql = 'DELETE FROM measurementunits WHERE measurementunitdescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempdelete($value) {
        $sql = 'DELETE FROM measurementunits WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrentdate($value) {
        $sql = 'DELETE FROM measurementunits WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MeasurementunitsMySql
     */
    protected function readRow($row) {
        $measurementunit = new Measurementunit();

        $measurementunit->measurementunitid = isset($row['measurementunitid']) ? $row['measurementunitid'] : '';
        $measurementunit->measurementunitname = isset($row['measurementunitname']) ? $row['measurementunitname'] : '';
        $measurementunit->measurementunitdescription = isset($row['measurementunitdescription']) ? $row['measurementunitdescription'] : '';
        $measurementunit->tempdelete = isset($row['tempdelete']) ? $row['tempdelete'] : '';
        $measurementunit->currentdate = isset($row['currentdate']) ? $row['currentdate'] : '';

        return $measurementunit;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MeasurementunitsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>