<?php

/**
 * Class that operate on table 'onlinetemporder'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-11-13 10:55
 */
class OnlinetemporderMySqlDAO implements OnlinetemporderDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return OnlinetemporderMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM onlinetemporder WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM onlinetemporder';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM onlinetemporder ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param onlinetemporder primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM onlinetemporder WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param OnlinetemporderMySql onlinetemporder
     */
    public function insert($onlinetemporder) {
        $sql = 'INSERT INTO onlinetemporder (onlineorderid, customerid, ordertotal, shippingcost, fulltotal, paytype, createdatetime, orderstatus, tax_value, userid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($onlinetemporder->onlineorderid);
        $sqlQuery->setNumber($onlinetemporder->customerid);
        $sqlQuery->set($onlinetemporder->ordertotal);
        $sqlQuery->set($onlinetemporder->shippingcost);
        $sqlQuery->set($onlinetemporder->fulltotal);
        $sqlQuery->set($onlinetemporder->paytype);
        $sqlQuery->set($onlinetemporder->createdatetime);
        $sqlQuery->setNumber($onlinetemporder->orderstatus);
        $sqlQuery->set($onlinetemporder->taxValue);
        $sqlQuery->setNumber($onlinetemporder->userid);

        $id = $this->executeInsert($sqlQuery);
        $onlinetemporder->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param OnlinetemporderMySql onlinetemporder
     */
    public function update($onlinetemporder) {
        $sql = 'UPDATE onlinetemporder SET onlineorderid = ?, customerid = ?, ordertotal = ?, shippingcost = ?, fulltotal = ?, paytype = ?, createdatetime = ?, orderstatus = ?, tax_value = ?, userid = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($onlinetemporder->onlineorderid);
        $sqlQuery->setNumber($onlinetemporder->customerid);
        $sqlQuery->set($onlinetemporder->ordertotal);
        $sqlQuery->set($onlinetemporder->shippingcost);
        $sqlQuery->set($onlinetemporder->fulltotal);
        $sqlQuery->set($onlinetemporder->paytype);
        $sqlQuery->set($onlinetemporder->createdatetime);
        $sqlQuery->setNumber($onlinetemporder->orderstatus);
        $sqlQuery->set($onlinetemporder->taxValue);
        $sqlQuery->setNumber($onlinetemporder->userid);

        $sqlQuery->setNumber($onlinetemporder->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM onlinetemporder';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOnlineorderid($value) {
        $sql = 'SELECT * FROM onlinetemporder WHERE onlineorderid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getRow($sqlQuery);
    }

    public function queryByCustomerid($value) {
        $sql = 'SELECT * FROM onlinetemporder WHERE customerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOrdertotal($value) {
        $sql = 'SELECT * FROM onlinetemporder WHERE ordertotal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShippingcost($value) {
        $sql = 'SELECT * FROM onlinetemporder WHERE shippingcost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByFulltotal($value) {
        $sql = 'SELECT * FROM onlinetemporder WHERE fulltotal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPaytype($value) {
        $sql = 'SELECT * FROM onlinetemporder WHERE paytype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCreatedatetime($value) {
        $sql = 'SELECT * FROM onlinetemporder WHERE createdatetime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOrderstatus($value) {
        $sql = 'SELECT * FROM onlinetemporder WHERE orderstatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTaxValue($value) {
        $sql = 'SELECT * FROM onlinetemporder WHERE tax_value = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM onlinetemporder WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOnlineorderid($value) {
        $sql = 'DELETE FROM onlinetemporder WHERE onlineorderid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCustomerid($value) {
        $sql = 'DELETE FROM onlinetemporder WHERE customerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOrdertotal($value) {
        $sql = 'DELETE FROM onlinetemporder WHERE ordertotal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShippingcost($value) {
        $sql = 'DELETE FROM onlinetemporder WHERE shippingcost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByFulltotal($value) {
        $sql = 'DELETE FROM onlinetemporder WHERE fulltotal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPaytype($value) {
        $sql = 'DELETE FROM onlinetemporder WHERE paytype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCreatedatetime($value) {
        $sql = 'DELETE FROM onlinetemporder WHERE createdatetime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOrderstatus($value) {
        $sql = 'DELETE FROM onlinetemporder WHERE orderstatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTaxValue($value) {
        $sql = 'DELETE FROM onlinetemporder WHERE tax_value = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM onlinetemporder WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return OnlinetemporderMySql
     */
    protected function readRow($row) {
        $onlinetemporder = new Onlinetemporder();

        $onlinetemporder->id = $row['id'];
        $onlinetemporder->onlineorderid = $row['onlineorderid'];
        $onlinetemporder->customerid = $row['customerid'];
        $onlinetemporder->ordertotal = $row['ordertotal'];
        $onlinetemporder->shippingcost = $row['shippingcost'];
        $onlinetemporder->fulltotal = $row['fulltotal'];
        $onlinetemporder->paytype = $row['paytype'];
        $onlinetemporder->createdatetime = $row['createdatetime'];
        $onlinetemporder->orderstatus = $row['orderstatus'];
        $onlinetemporder->taxValue = $row['tax_value'];
        $onlinetemporder->userid = $row['userid'];
        //
        $onlinetemporder->clientname = $row['clientname'];
        $onlinetemporder->clientmobile = $row['clientmobile'];
        $onlinetemporder->erpid = $row['erpid'];

        return $onlinetemporder;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return OnlinetemporderMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>