<?php
/**
 * Class that operate on table 'playstationclientcardpayhistory'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-06-24 11:58
 */
class PlaystationclientcardpayhistoryMySqlDAO implements PlaystationclientcardpayhistoryDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return PlaystationclientcardpayhistoryMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM playstationclientcardpayhistory WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM playstationclientcardpayhistory';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM playstationclientcardpayhistory ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param playstationclientcardpayhistory primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM playstationclientcardpayhistory WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param PlaystationclientcardpayhistoryMySql playstationclientcardpayhistory
 	 */
	public function insert($playstationclientcardpayhistory){
		$sql = 'INSERT INTO playstationclientcardpayhistory (clientid, cardid, cardValBefore, payAmount, changeType, cardValAfter, processname, modelid, tablename, comment, conditions, userid, sysDate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($playstationclientcardpayhistory->clientid);
		$sqlQuery->setNumber($playstationclientcardpayhistory->cardid);
		$sqlQuery->set($playstationclientcardpayhistory->cardValBefore);
		$sqlQuery->set($playstationclientcardpayhistory->payAmount);
		$sqlQuery->setNumber($playstationclientcardpayhistory->changeType);
		$sqlQuery->set($playstationclientcardpayhistory->cardValAfter);
		$sqlQuery->set($playstationclientcardpayhistory->processname);
		$sqlQuery->setNumber($playstationclientcardpayhistory->modelid);
		$sqlQuery->set($playstationclientcardpayhistory->tablename);
		$sqlQuery->setString2($playstationclientcardpayhistory->comment);
		$sqlQuery->setNumber($playstationclientcardpayhistory->conditions);
		$sqlQuery->setNumber($playstationclientcardpayhistory->userid);
		$sqlQuery->set($playstationclientcardpayhistory->sysDate);

		$id = $this->executeInsert($sqlQuery);	
		$playstationclientcardpayhistory->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param PlaystationclientcardpayhistoryMySql playstationclientcardpayhistory
 	 */
	public function update($playstationclientcardpayhistory){
		$sql = 'UPDATE playstationclientcardpayhistory SET clientid = ?, cardid = ?, cardValBefore = ?, payAmount = ?, changeType = ?, cardValAfter = ?, processname = ?, modelid = ?, tablename = ?, comment = ?, conditions = ?, userid = ?, sysDate = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($playstationclientcardpayhistory->clientid);
		$sqlQuery->setNumber($playstationclientcardpayhistory->cardid);
		$sqlQuery->set($playstationclientcardpayhistory->cardValBefore);
		$sqlQuery->set($playstationclientcardpayhistory->payAmount);
		$sqlQuery->setNumber($playstationclientcardpayhistory->changeType);
		$sqlQuery->set($playstationclientcardpayhistory->cardValAfter);
		$sqlQuery->set($playstationclientcardpayhistory->processname);
		$sqlQuery->setNumber($playstationclientcardpayhistory->modelid);
		$sqlQuery->set($playstationclientcardpayhistory->tablename);
		$sqlQuery->setString2($playstationclientcardpayhistory->comment);
		$sqlQuery->setNumber($playstationclientcardpayhistory->conditions);
		$sqlQuery->setNumber($playstationclientcardpayhistory->userid);
		$sqlQuery->set($playstationclientcardpayhistory->sysDate);

		$sqlQuery->setNumber($playstationclientcardpayhistory->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM playstationclientcardpayhistory';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByClientid($value){
		$sql = 'SELECT * FROM playstationclientcardpayhistory WHERE clientid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCardid($value){
		$sql = 'SELECT * FROM playstationclientcardpayhistory WHERE cardid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCardValBefore($value){
		$sql = 'SELECT * FROM playstationclientcardpayhistory WHERE cardValBefore = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPayAmount($value){
		$sql = 'SELECT * FROM playstationclientcardpayhistory WHERE payAmount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByChangeType($value){
		$sql = 'SELECT * FROM playstationclientcardpayhistory WHERE changeType = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCardValAfter($value){
		$sql = 'SELECT * FROM playstationclientcardpayhistory WHERE cardValAfter = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProcessname($value){
		$sql = 'SELECT * FROM playstationclientcardpayhistory WHERE processname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModelid($value){
		$sql = 'SELECT * FROM playstationclientcardpayhistory WHERE modelid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTablename($value){
		$sql = 'SELECT * FROM playstationclientcardpayhistory WHERE tablename = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByComment($value){
		$sql = 'SELECT * FROM playstationclientcardpayhistory WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM playstationclientcardpayhistory WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM playstationclientcardpayhistory WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysDate($value){
		$sql = 'SELECT * FROM playstationclientcardpayhistory WHERE sysDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByClientid($value){
		$sql = 'DELETE FROM playstationclientcardpayhistory WHERE clientid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCardid($value){
		$sql = 'DELETE FROM playstationclientcardpayhistory WHERE cardid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCardValBefore($value){
		$sql = 'DELETE FROM playstationclientcardpayhistory WHERE cardValBefore = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPayAmount($value){
		$sql = 'DELETE FROM playstationclientcardpayhistory WHERE payAmount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByChangeType($value){
		$sql = 'DELETE FROM playstationclientcardpayhistory WHERE changeType = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCardValAfter($value){
		$sql = 'DELETE FROM playstationclientcardpayhistory WHERE cardValAfter = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProcessname($value){
		$sql = 'DELETE FROM playstationclientcardpayhistory WHERE processname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModelid($value){
		$sql = 'DELETE FROM playstationclientcardpayhistory WHERE modelid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTablename($value){
		$sql = 'DELETE FROM playstationclientcardpayhistory WHERE tablename = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByComment($value){
		$sql = 'DELETE FROM playstationclientcardpayhistory WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM playstationclientcardpayhistory WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM playstationclientcardpayhistory WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysDate($value){
		$sql = 'DELETE FROM playstationclientcardpayhistory WHERE sysDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return PlaystationclientcardpayhistoryMySql 
	 */
	protected function readRow($row){
		$playstationclientcardpayhistory = new Playstationclientcardpayhistory();
		
		$playstationclientcardpayhistory->id = $row['id'];
		$playstationclientcardpayhistory->clientid = $row['clientid'];
		$playstationclientcardpayhistory->cardid = $row['cardid'];
		$playstationclientcardpayhistory->cardValBefore = $row['cardValBefore'];
		$playstationclientcardpayhistory->payAmount = $row['payAmount'];
		$playstationclientcardpayhistory->changeType = $row['changeType'];
		$playstationclientcardpayhistory->cardValAfter = $row['cardValAfter'];
		$playstationclientcardpayhistory->processname = $row['processname'];
		$playstationclientcardpayhistory->modelid = $row['modelid'];
		$playstationclientcardpayhistory->tablename = $row['tablename'];
		$playstationclientcardpayhistory->comment = $row['comment'];
		$playstationclientcardpayhistory->conditions = $row['conditions'];
		$playstationclientcardpayhistory->userid = $row['userid'];
		$playstationclientcardpayhistory->sysDate = $row['sysDate'];

		return $playstationclientcardpayhistory;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return PlaystationclientcardpayhistoryMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>