<?php

/**
 * Class that operate on table 'productrecieve'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-09-29 12:20
 */
class ProductrecieveMySqlDAO implements ProductrecieveDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductrecieveMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productrecieve WHERE productrecieveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productrecieve';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productrecieve ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productrecieve primary key
     */
    public function delete($productrecieveid) {
        $sql = 'DELETE FROM productrecieve WHERE productrecieveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($productrecieveid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductrecieveMySql productrecieve
     */
    public function insert($productrecieve) {
        $sql = 'INSERT INTO productrecieve (sparepartid, productrecievedate, recieptnum, clientname, type, cost, partsnumber, userid) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productrecieve->sparepartid);
        $sqlQuery->set($productrecieve->productrecievedate);
        $sqlQuery->set($productrecieve->recieptnum);
        $sqlQuery->set($productrecieve->clientname);
        $sqlQuery->setNumber($productrecieve->type);
        $sqlQuery->set($productrecieve->cost);
        $sqlQuery->setNumber($productrecieve->partsnumber);
        $sqlQuery->setNumber($productrecieve->userid);

        $id = $this->executeInsert($sqlQuery);
        $productrecieve->productrecieveid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductrecieveMySql productrecieve
     */
    public function update($productrecieve) {
        $sql = 'UPDATE productrecieve SET sparepartid = ?, productrecievedate = ?, recieptnum = ?, clientname = ?, type = ?, cost = ?, partsnumber = ?, userid = ? WHERE productrecieveid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productrecieve->sparepartid);
        $sqlQuery->set($productrecieve->productrecievedate);
        $sqlQuery->set($productrecieve->recieptnum);
        $sqlQuery->set($productrecieve->clientname);
        $sqlQuery->setNumber($productrecieve->type);
        $sqlQuery->set($productrecieve->cost);
        $sqlQuery->setNumber($productrecieve->partsnumber);
        $sqlQuery->setNumber($productrecieve->userid);

        $sqlQuery->setNumber($productrecieve->productrecieveid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productrecieve';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySparepartid($value) {
        $sql = 'SELECT * FROM productrecieve WHERE sparepartid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductrecievedate($value) {
        $sql = 'SELECT * FROM productrecieve WHERE productrecievedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRecieptnum($value) {
        $sql = 'SELECT * FROM productrecieve WHERE recieptnum = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientname($value) {
        $sql = 'SELECT * FROM productrecieve WHERE clientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByType($value) {
        $sql = 'SELECT * FROM productrecieve WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCost($value) {
        $sql = 'SELECT * FROM productrecieve WHERE cost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPartsnumber($value) {
        $sql = 'SELECT * FROM productrecieve WHERE partsnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM productrecieve WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySparepartid($value) {
        $sql = 'DELETE FROM productrecieve WHERE sparepartid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductrecievedate($value) {
        $sql = 'DELETE FROM productrecieve WHERE productrecievedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRecieptnum($value) {
        $sql = 'DELETE FROM productrecieve WHERE recieptnum = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientname($value) {
        $sql = 'DELETE FROM productrecieve WHERE clientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByType($value) {
        $sql = 'DELETE FROM productrecieve WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCost($value) {
        $sql = 'DELETE FROM productrecieve WHERE cost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPartsnumber($value) {
        $sql = 'DELETE FROM productrecieve WHERE partsnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM productrecieve WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductrecieveMySql
     */
    protected function readRow($row) {
        $productrecieve = new Productrecieve();

        $productrecieve->productrecieveid = isset($row['productrecieveid']) ? $row['productrecieveid'] : '';
        $productrecieve->sparepartid = isset($row['sparepartid']) ? $row['sparepartid'] : '';
        $productrecieve->productrecievedate = isset($row['productrecievedate']) ? $row['productrecievedate'] : '';
        $productrecieve->recieptnum = isset($row['recieptnum']) ? $row['recieptnum'] : '';
        $productrecieve->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $productrecieve->type = isset($row['type']) ? $row['type'] : '';
        $productrecieve->cost = isset($row['cost']) ? $row['cost'] : '';
        $productrecieve->partsnumber = isset($row['partsnumber']) ? $row['partsnumber'] : '';
        $productrecieve->userid = isset($row['userid']) ? $row['userid'] : '';

        //required
        $productrecieve->sparepartname = isset($row['sparepartname']) ? $row['sparepartname'] : '';
        [''];

        return $productrecieve;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductrecieveMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>