<?php

/**
 * Class that operate on table 'producttempunit'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-05-07 12:40
 */
class ProducttempunitMySqlDAO implements ProducttempunitDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProducttempunitMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM producttempunit WHERE producttempunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM producttempunit';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM producttempunit ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param producttempunit primary key
     */
    public function delete($producttempunitid) {
        $sql = 'DELETE FROM producttempunit WHERE producttempunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($producttempunitid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProducttempunitMySql producttempunit
     */
    public function insert($producttempunit) {
        $sql = 'INSERT INTO producttempunit (unitid, producttempid, productnumber, producttempunitdate, userid, conditions) VALUES (?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($producttempunit->unitid);
        $sqlQuery->setNumber($producttempunit->producttempid);
        $sqlQuery->setNumber($producttempunit->productnumber);
        $sqlQuery->set($producttempunit->producttempunitdate);
        $sqlQuery->setNumber($producttempunit->userid);
        $sqlQuery->setNumber($producttempunit->conditions);

        $id = $this->executeInsert($sqlQuery);
        $producttempunit->producttempunitid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProducttempunitMySql producttempunit
     */
    public function update($producttempunit) {
        $sql = 'UPDATE producttempunit SET unitid = ?, producttempid = ?, productnumber = ?, producttempunitdate = ?, userid = ?, conditions = ? WHERE producttempunitid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($producttempunit->unitid);
        $sqlQuery->setNumber($producttempunit->producttempid);
        $sqlQuery->setNumber($producttempunit->productnumber);
        $sqlQuery->set($producttempunit->producttempunitdate);
        $sqlQuery->setNumber($producttempunit->userid);
        $sqlQuery->setNumber($producttempunit->conditions);

        $sqlQuery->setNumber($producttempunit->producttempunitid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM producttempunit';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByUnitid($value) {
        $sql = 'SELECT * FROM producttempunit WHERE unitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProducttempid($value) {
        $sql = 'SELECT * FROM producttempunit WHERE producttempid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductnumber($value) {
        $sql = 'SELECT * FROM producttempunit WHERE productnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProducttempunitdate($value) {
        $sql = 'SELECT * FROM producttempunit WHERE producttempunitdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM producttempunit WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM producttempunit WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByUnitid($value) {
        $sql = 'DELETE FROM producttempunit WHERE unitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProducttempid($value) {
        $sql = 'DELETE FROM producttempunit WHERE producttempid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductnumber($value) {
        $sql = 'DELETE FROM producttempunit WHERE productnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProducttempunitdate($value) {
        $sql = 'DELETE FROM producttempunit WHERE producttempunitdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM producttempunit WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM producttempunit WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProducttempunitMySql
     */
    protected function readRow($row) {
        $producttempunit = new Producttempunit();

        $producttempunit->producttempunitid = isset($row['producttempunitid']) ? $row['producttempunitid'] : '';
        $producttempunit->unitid = isset($row['unitid']) ? $row['unitid'] : '';
        $producttempunit->producttempid = isset($row['producttempid']) ? $row['producttempid'] : '';
        $producttempunit->productnumber = isset($row['productnumber']) ? $row['productnumber'] : '';
        $producttempunit->producttempunitdate = isset($row['producttempunitdate']) ? $row['producttempunitdate'] : '';
        $producttempunit->userid = isset($row['userid']) ? $row['userid'] : '';
        $producttempunit->conditions = isset($row['conditions']) ? $row['conditions'] : '';

        return $producttempunit;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProducttempunitMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>