<?php

/**
 * Class that operate on table 'projectexchmaterial'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-28 14:17
 */
class ProjectexchmaterialMySqlDAO implements ProjectexchmaterialDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProjectexchmaterialMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM projectexchmaterial WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM projectexchmaterial';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM projectexchmaterial ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param projectexchmaterial primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM projectexchmaterial WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProjectexchmaterialMySql projectexchmaterial
     */
    public function insert($projectexchmaterial) {
        $sql = 'INSERT INTO projectexchmaterial (serilno, projectid, storeid, projdate, sysdate, totalnum,totalbuyprice,entryid) VALUES (?,?,?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($projectexchmaterial->serilno);
        $sqlQuery->setNumber($projectexchmaterial->projectid);
        $sqlQuery->setNumber($projectexchmaterial->storeid);
        $sqlQuery->set($projectexchmaterial->projdate);
        $sqlQuery->set($projectexchmaterial->sysdate);
        $sqlQuery->set($projectexchmaterial->totalnum);
        $sqlQuery->set($projectexchmaterial->totalbuyprice);
        $sqlQuery->setNumber($projectexchmaterial->entryid);

        $id = $this->executeInsert($sqlQuery);
        $projectexchmaterial->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProjectexchmaterialMySql projectexchmaterial
     */
    public function update($projectexchmaterial) {
        $sql = 'UPDATE projectexchmaterial SET serilno = ?, projectid = ?, storeid = ?, projdate = ?, sysdate = ?, totalnum = ?,totalbuyprice = ?,entryid =? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($projectexchmaterial->serilno);
        $sqlQuery->setNumber($projectexchmaterial->projectid);
        $sqlQuery->setNumber($projectexchmaterial->storeid);
        $sqlQuery->set($projectexchmaterial->projdate);
        $sqlQuery->set($projectexchmaterial->sysdate);
        $sqlQuery->set($projectexchmaterial->totalnum);
        $sqlQuery->set($projectexchmaterial->totalbuyprice);
        $sqlQuery->setNumber($projectexchmaterial->entryid);

        $sqlQuery->setNumber($projectexchmaterial->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM projectexchmaterial';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySerilno($value) {
        $sql = 'SELECT * FROM projectexchmaterial WHERE serilno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProjectid($value) {
        $sql = 'SELECT * FROM projectexchmaterial WHERE projectid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM projectexchmaterial WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProjdate($value) {
        $sql = 'SELECT * FROM projectexchmaterial WHERE projdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM projectexchmaterial WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotalnum($value) {
        $sql = 'SELECT * FROM projectexchmaterial WHERE totalnum = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySerilno($value) {
        $sql = 'DELETE FROM projectexchmaterial WHERE serilno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProjectid($value) {
        $sql = 'DELETE FROM projectexchmaterial WHERE projectid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM projectexchmaterial WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProjdate($value) {
        $sql = 'DELETE FROM projectexchmaterial WHERE projdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM projectexchmaterial WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotalnum($value) {
        $sql = 'DELETE FROM projectexchmaterial WHERE totalnum = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProjectexchmaterialMySql
     */
    protected function readRow($row) {
        $projectexchmaterial = new Projectexchmaterial();

        $projectexchmaterial->id = isset($row['id']) ? $row['id'] : '';
        $projectexchmaterial->serilno = isset($row['serilno']) ? $row['serilno'] : '';
        $projectexchmaterial->projectid = isset($row['projectid']) ? $row['projectid'] : '';
        $projectexchmaterial->storeid = isset($row['storeid']) ? $row['storeid'] : '';
        $projectexchmaterial->projdate = isset($row['projdate']) ? $row['projdate'] : '';
        $projectexchmaterial->sysdate = isset($row['sysdate']) ? $row['sysdate'] : '';
        $projectexchmaterial->totalnum = isset($row['totalnum']) ? $row['totalnum'] : '';
        $projectexchmaterial->totalbuyprice = isset($row['totalbuyprice']) ? $row['totalbuyprice'] : '';
        $projectexchmaterial->entryid = isset($row['entryid']) ? $row['entryid'] : '';


        return $projectexchmaterial;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProjectexchmaterialMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>