<?php
/**
 * Class that operate on table 'projectkind'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-09-11 21:40
 */
class ProjectkindMySqlDAO implements ProjectkindDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return ProjectkindMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM projectkind WHERE projectkindid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM projectkind';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM projectkind ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param projectkind primary key
 	 */
	public function delete($projectkindid){
		$sql = 'DELETE FROM projectkind WHERE projectkindid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($projectkindid);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param ProjectkindMySql projectkind
 	 */
	public function insert($projectkind){
		$sql = 'INSERT INTO projectkind (projectkindname, projectkinddate, userid, conditions, projectkindcomment) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($projectkind->projectkindname);
		$sqlQuery->set($projectkind->projectkinddate);
		$sqlQuery->setNumber($projectkind->userid);
		$sqlQuery->setNumber($projectkind->conditions);
		$sqlQuery->setString2($projectkind->projectkindcomment);

		$id = $this->executeInsert($sqlQuery);	
		$projectkind->projectkindid = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param ProjectkindMySql projectkind
 	 */
	public function update($projectkind){
		$sql = 'UPDATE projectkind SET projectkindname = ?, projectkinddate = ?, userid = ?, conditions = ?, projectkindcomment = ? WHERE projectkindid = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($projectkind->projectkindname);
		$sqlQuery->set($projectkind->projectkinddate);
		$sqlQuery->setNumber($projectkind->userid);
		$sqlQuery->setNumber($projectkind->conditions);
		$sqlQuery->setString2($projectkind->projectkindcomment);

		$sqlQuery->setNumber($projectkind->projectkindid);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM projectkind';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByProjectkindname($value){
		$sql = 'SELECT * FROM projectkind WHERE projectkindname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProjectkinddate($value){
		$sql = 'SELECT * FROM projectkind WHERE projectkinddate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM projectkind WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM projectkind WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProjectkindcomment($value){
		$sql = 'SELECT * FROM projectkind WHERE projectkindcomment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByProjectkindname($value){
		$sql = 'DELETE FROM projectkind WHERE projectkindname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProjectkinddate($value){
		$sql = 'DELETE FROM projectkind WHERE projectkinddate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM projectkind WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM projectkind WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProjectkindcomment($value){
		$sql = 'DELETE FROM projectkind WHERE projectkindcomment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return ProjectkindMySql 
	 */
	protected function readRow($row){
		$projectkind = new Projectkind();
		
		$projectkind->projectkindid = $row['projectkindid'];
		$projectkind->projectkindname = $row['projectkindname'];
		$projectkind->projectkinddate = $row['projectkinddate'];
		$projectkind->userid = $row['userid'];
		$projectkind->conditions = $row['conditions'];
		$projectkind->projectkindcomment = $row['projectkindcomment'];

		return $projectkind;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return ProjectkindMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>