<?php

/**
 * Class that operate on table 'quickprofitproduct'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-01-21 13:45
 */
class QuickprofitproductMySqlDAO implements QuickprofitproductDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return QuickprofitproductMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM quickprofitproduct';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM quickprofitproduct ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param quickprofitproduct primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM quickprofitproduct WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param QuickprofitproductMySql quickprofitproduct
     */
    public function insert($quickprofitproduct) {
        $sql = 'INSERT INTO quickprofitproduct (productId, theDate, sellVal, sellCostBuyPrice, sellCostLastBuyPrice, sellCostMeanBuyPrice, sellCostLastBuyPricewithDiscount, sellCostMeanBuyPricewithDiscount, returnSellVal, returnSellCostBuyPrice, returnSellCostLastBuyPrice, returnSellCostMeanBuyPrice, returnSellCostLastBuyPricewithDiscount, returnSellCostMeanBuyPricewithDiscount,netQuantity,netQuantityRet) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($quickprofitproduct->productId);
        $sqlQuery->set($quickprofitproduct->theDate);
        $sqlQuery->set($quickprofitproduct->sellVal);
        $sqlQuery->set($quickprofitproduct->sellCostBuyPrice);
        $sqlQuery->set($quickprofitproduct->sellCostLastBuyPrice);
        $sqlQuery->set($quickprofitproduct->sellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitproduct->sellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitproduct->sellCostMeanBuyPricewithDiscount);
        $sqlQuery->set($quickprofitproduct->returnSellVal);
        $sqlQuery->set($quickprofitproduct->returnSellCostBuyPrice);
        $sqlQuery->set($quickprofitproduct->returnSellCostLastBuyPrice);
        $sqlQuery->set($quickprofitproduct->returnSellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitproduct->returnSellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitproduct->returnSellCostMeanBuyPricewithDiscount);
        $sqlQuery->setNumber($quickprofitproduct->netQuantity);
        $sqlQuery->setNumber($quickprofitproduct->netQuantityRet);

        $id = $this->executeInsert($sqlQuery);
        $quickprofitproduct->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param QuickprofitproductMySql quickprofitproduct
     */
    public function update($quickprofitproduct) {
        $sql = 'UPDATE quickprofitproduct SET productId = ?, theDate = ?, sellVal = ?, sellCostBuyPrice = ?, sellCostLastBuyPrice = ?, sellCostMeanBuyPrice = ?, sellCostLastBuyPricewithDiscount = ?, sellCostMeanBuyPricewithDiscount = ?, returnSellVal = ?, returnSellCostBuyPrice = ?, returnSellCostLastBuyPrice = ?, returnSellCostMeanBuyPrice = ?, returnSellCostLastBuyPricewithDiscount = ?, returnSellCostMeanBuyPricewithDiscount = ?, netQuantity = ?, netQuantityRet = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($quickprofitproduct->productId);
        $sqlQuery->set($quickprofitproduct->theDate);
        $sqlQuery->set($quickprofitproduct->sellVal);
        $sqlQuery->set($quickprofitproduct->sellCostBuyPrice);
        $sqlQuery->set($quickprofitproduct->sellCostLastBuyPrice);
        $sqlQuery->set($quickprofitproduct->sellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitproduct->sellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitproduct->sellCostMeanBuyPricewithDiscount);
        $sqlQuery->set($quickprofitproduct->returnSellVal);
        $sqlQuery->set($quickprofitproduct->returnSellCostBuyPrice);
        $sqlQuery->set($quickprofitproduct->returnSellCostLastBuyPrice);
        $sqlQuery->set($quickprofitproduct->returnSellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitproduct->returnSellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitproduct->returnSellCostMeanBuyPricewithDiscount);
        $sqlQuery->setNumber($quickprofitproduct->netQuantity);
        $sqlQuery->setNumber($quickprofitproduct->netQuantityRet);

        $sqlQuery->setNumber($quickprofitproduct->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM quickprofitproduct';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductId($value) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTheDate($value) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE theDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellVal($value) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE sellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE sellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostLastBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE sellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostMeanBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE sellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostLastBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE sellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostMeanBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE sellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellVal($value) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE returnSellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE returnSellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostLastBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE returnSellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostMeanBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE returnSellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostLastBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE returnSellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostMeanBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitproduct WHERE returnSellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductId($value) {
        $sql = 'DELETE FROM quickprofitproduct WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTheDate($value) {
        $sql = 'DELETE FROM quickprofitproduct WHERE theDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellVal($value) {
        $sql = 'DELETE FROM quickprofitproduct WHERE sellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitproduct WHERE sellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostLastBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitproduct WHERE sellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostMeanBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitproduct WHERE sellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostLastBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitproduct WHERE sellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostMeanBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitproduct WHERE sellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellVal($value) {
        $sql = 'DELETE FROM quickprofitproduct WHERE returnSellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitproduct WHERE returnSellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostLastBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitproduct WHERE returnSellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostMeanBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitproduct WHERE returnSellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostLastBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitproduct WHERE returnSellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostMeanBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitproduct WHERE returnSellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return QuickprofitproductMySql
     */
    protected function readRow($row) {
        $quickprofitproduct = new Quickprofitproduct();

        $quickprofitproduct->id = $row['id'];
        $quickprofitproduct->productId = $row['productId'];
        $quickprofitproduct->theDate = $row['theDate'];
        $quickprofitproduct->sellVal = $row['sellVal'];
        $quickprofitproduct->sellCostBuyPrice = $row['sellCostBuyPrice'];
        $quickprofitproduct->sellCostLastBuyPrice = $row['sellCostLastBuyPrice'];
        $quickprofitproduct->sellCostMeanBuyPrice = $row['sellCostMeanBuyPrice'];
        $quickprofitproduct->sellCostLastBuyPricewithDiscount = $row['sellCostLastBuyPricewithDiscount'];
        $quickprofitproduct->sellCostMeanBuyPricewithDiscount = $row['sellCostMeanBuyPricewithDiscount'];
        $quickprofitproduct->sellCostOverAllAveragePrice = $row['sellCostOverAllAveragePrice'];
        $quickprofitproduct->returnSellVal = $row['returnSellVal'];
        $quickprofitproduct->returnSellCostBuyPrice = $row['returnSellCostBuyPrice'];
        $quickprofitproduct->returnSellCostLastBuyPrice = $row['returnSellCostLastBuyPrice'];
        $quickprofitproduct->returnSellCostMeanBuyPrice = $row['returnSellCostMeanBuyPrice'];
        $quickprofitproduct->returnSellCostLastBuyPricewithDiscount = $row['returnSellCostLastBuyPricewithDiscount'];
        $quickprofitproduct->returnSellCostMeanBuyPricewithDiscount = $row['returnSellCostMeanBuyPricewithDiscount'];
        $quickprofitproduct->returnSellCostOverAllAveragePrice = $row['returnSellCostOverAllAveragePrice'];
        $quickprofitproduct->netQuantity = $row['netQuantity'];
        $quickprofitproduct->netQuantityRet = $row['netQuantityRet'];
        //
        $quickprofitproduct->productName = $row['productName'];
        $quickprofitproduct->productCatName = $row['productCatName'];
        return $quickprofitproduct;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return QuickprofitproductMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>