<?php

/**
 * Class that operate on table 'restauranthall'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-05-16 11:37
 */
class RestauranthallMySqlDAO implements RestauranthallDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RestauranthallMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM restauranthall WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM restauranthall';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM restauranthall ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param restauranthall primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM restauranthall WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RestauranthallMySql restauranthall
     */
    public function insert($restauranthall) {
        $sql = 'INSERT INTO restauranthall (name,hallPrice, hallUsers, userId, sysdate, del) VALUES (?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($restauranthall->name);
        $sqlQuery->setNumber($restauranthall->hallPrice);
        $sqlQuery->set($restauranthall->hallUsers);
        $sqlQuery->setNumber($restauranthall->userId);
        $sqlQuery->set($restauranthall->sysdate);
        $sqlQuery->setNumber($restauranthall->del);

        $id = $this->executeInsert($sqlQuery);
        $restauranthall->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RestauranthallMySql restauranthall
     */
    public function update($restauranthall) {
        $sql = 'UPDATE restauranthall SET name = ?, hallPrice = ?, hallUsers = ?, userId = ?, sysdate = ?, del = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($restauranthall->name);
        $sqlQuery->setNumber($restauranthall->hallPrice);
        $sqlQuery->set($restauranthall->hallUsers);
        $sqlQuery->setNumber($restauranthall->userId);
        $sqlQuery->set($restauranthall->sysdate);
        $sqlQuery->setNumber($restauranthall->del);

        $sqlQuery->setNumber($restauranthall->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM restauranthall';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM restauranthall WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByHallUsers($value) {
        $sql = 'SELECT * FROM restauranthall WHERE hallUsers = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM restauranthall WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM restauranthall WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM restauranthall WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM restauranthall WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByHallUsers($value) {
        $sql = 'DELETE FROM restauranthall WHERE hallUsers = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM restauranthall WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM restauranthall WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM restauranthall WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RestauranthallMySql
     */
    protected function readRow($row) {
        $restauranthall = new Restauranthall();

        $restauranthall->id = isset($row['id']) ? $row['id'] : '';
        $restauranthall->name = isset($row['name']) ? $row['name'] : '';
        $restauranthall->hallPrice = isset($row['hallPrice']) ? $row['hallPrice'] : '';
        $restauranthall->hallUsers = isset($row['hallUsers']) ? $row['hallUsers'] : '';
        $restauranthall->userId = isset($row['userId']) ? $row['userId'] : '';
        $restauranthall->sysdate = isset($row['sysdate']) ? $row['sysdate'] : '';
        $restauranthall->del = isset($row['del']) ? $row['del'] : '';

        return $restauranthall;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RestauranthallMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>