<?php

/**
 * Class that operate on table 'restaurantkitchenprint'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-05-26 15:04
 */
class RestaurantkitchenprintMySqlDAO implements RestaurantkitchenprintDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RestaurantkitchenprintMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM restaurantkitchenprint WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM restaurantkitchenprint';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM restaurantkitchenprint ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param restaurantkitchenprint primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM restaurantkitchenprint WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RestaurantkitchenprintMySql restaurantkitchenprint
     */
    public function insert($restaurantkitchenprint) {
        $sql = 'INSERT INTO restaurantkitchenprint (orderId, productId, quantity,notesPrinted, togetherNo, isPrinted,sysDateTime) VALUES (?, ?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($restaurantkitchenprint->orderId);
        $sqlQuery->setNumber($restaurantkitchenprint->productId);
        $sqlQuery->setNumber($restaurantkitchenprint->quantity);
        $sqlQuery->set($restaurantkitchenprint->notesPrinted);
        $sqlQuery->setNumber($restaurantkitchenprint->togetherNo);
        $sqlQuery->setNumber($restaurantkitchenprint->isPrinted);
        $sqlQuery->set($restaurantkitchenprint->sysDateTime);

        $id = $this->executeInsert($sqlQuery);
        $restaurantkitchenprint->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RestaurantkitchenprintMySql restaurantkitchenprint
     */
    public function update($restaurantkitchenprint) {
        $sql = 'UPDATE restaurantkitchenprint SET orderId = ?, productId = ?, quantity = ?,notesPrinted = ?, togetherNo = ?, isPrinted = ?,sysDateTime = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($restaurantkitchenprint->orderId);
        $sqlQuery->setNumber($restaurantkitchenprint->productId);
        $sqlQuery->setNumber($restaurantkitchenprint->quantity);
        $sqlQuery->set($restaurantkitchenprint->notesPrinted);
        $sqlQuery->setNumber($restaurantkitchenprint->togetherNo);
        $sqlQuery->setNumber($restaurantkitchenprint->isPrinted);
        $sqlQuery->set($restaurantkitchenprint->sysDateTime);

        $sqlQuery->setNumber($restaurantkitchenprint->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM restaurantkitchenprint';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOrderId($value) {
        $sql = 'SELECT * FROM restaurantkitchenprint WHERE orderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductId($value) {
        $sql = 'SELECT * FROM restaurantkitchenprint WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM restaurantkitchenprint WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTogetherNo($value) {
        $sql = 'SELECT * FROM restaurantkitchenprint WHERE togetherNo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIsPrinted($value) {
        $sql = 'SELECT * FROM restaurantkitchenprint WHERE isPrinted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOrderId($value) {
        $sql = 'DELETE FROM restaurantkitchenprint WHERE orderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductId($value) {
        $sql = 'DELETE FROM restaurantkitchenprint WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM restaurantkitchenprint WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTogetherNo($value) {
        $sql = 'DELETE FROM restaurantkitchenprint WHERE togetherNo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIsPrinted($value) {
        $sql = 'DELETE FROM restaurantkitchenprint WHERE isPrinted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RestaurantkitchenprintMySql
     */
    protected function readRow($row) {
        $restaurantkitchenprint = new Restaurantkitchenprint();

        $restaurantkitchenprint->id = isset($row['id']) ? $row['id'] : '';
        $restaurantkitchenprint->orderId = isset($row['orderId']) ? $row['orderId'] : '';
        $restaurantkitchenprint->productId = isset($row['productId']) ? $row['productId'] : '';
        $restaurantkitchenprint->quantity = isset($row['quantity']) ? $row['quantity'] : '';
        $restaurantkitchenprint->notesPrinted = isset($row['notesPrinted']) ? $row['notesPrinted'] : '';
        $restaurantkitchenprint->togetherNo = isset($row['togetherNo']) ? $row['togetherNo'] : '';
        $restaurantkitchenprint->isPrinted = isset($row['isPrinted']) ? $row['isPrinted'] : '';
        $restaurantkitchenprint->sysDateTime = isset($row['sysDateTime']) ? $row['sysDateTime'] : '';
        //
        $restaurantkitchenprint->productName = isset($row['productName']) ? $row['productName'] : '';
        $restaurantkitchenprint->tableId = isset($row['tableId']) ? $row['tableId'] : '';
        $restaurantkitchenprint->hallName = isset($row['hallName']) ? $row['hallName'] : '';
        $restaurantkitchenprint->daySreial = isset($row['daySreial']) ? $row['daySreial'] : '';
        $restaurantkitchenprint->billComment = isset($row['billComment']) ? $row['billComment'] : '';
        $restaurantkitchenprint->fromBillDirectWithId = isset($row['fromBillDirectWithId']) ? $row['fromBillDirectWithId'] : '';

        return $restaurantkitchenprint;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RestaurantkitchenprintMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>