<?php

/**
 * Class that operate on table 'restaurantplaystationplay'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-04-05 19:36
 */
class RestaurantplaystationplayMySqlDAO implements RestaurantplaystationplayDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RestaurantplaystationplayMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM restaurantplaystationplay';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM restaurantplaystationplay ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param restaurantplaystationplay primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RestaurantplaystationplayMySql restaurantplaystationplay
     */
    public function insert($restaurantplaystationplay) {
        $sql = 'INSERT INTO restaurantplaystationplay (playstationid, hourPrice, startsysDate, endsysDate, duration, note, totalPrice, discount, tax, netPrice, payed, finished, sellBillId, userId, sysdate, del, reservationType, reservationHours, reservationMinutes, reservationEndDateTime,moveStartSysDate,moveDuration, oldPsPlayid, startPrice,cardPayed,cashPayed,psClientCardId,priceIs,hourPriceMulti,allMovesUnitedSellBillId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($restaurantplaystationplay->playstationid);
        $sqlQuery->set($restaurantplaystationplay->hourPrice);
        $sqlQuery->set($restaurantplaystationplay->startsysDate);
        $sqlQuery->set($restaurantplaystationplay->endsysDate);
        $sqlQuery->set($restaurantplaystationplay->duration);
        $sqlQuery->setString2($restaurantplaystationplay->note);
        $sqlQuery->set($restaurantplaystationplay->totalPrice);
        $sqlQuery->set($restaurantplaystationplay->discount);
        $sqlQuery->set($restaurantplaystationplay->tax);
        $sqlQuery->set($restaurantplaystationplay->netPrice);
        $sqlQuery->set($restaurantplaystationplay->payed);
        $sqlQuery->setNumber($restaurantplaystationplay->finished);
        $sqlQuery->setNumber($restaurantplaystationplay->sellBillId);
        $sqlQuery->setNumber($restaurantplaystationplay->userId);
        $sqlQuery->set($restaurantplaystationplay->sysdate);
        $sqlQuery->setNumber($restaurantplaystationplay->del);
        $sqlQuery->setNumber($restaurantplaystationplay->reservationType);
        $sqlQuery->setNumber($restaurantplaystationplay->reservationHours);
        $sqlQuery->setNumber($restaurantplaystationplay->reservationMinutes);
        $sqlQuery->set($restaurantplaystationplay->reservationEndDateTime);
        $sqlQuery->set($restaurantplaystationplay->moveStartSysDate);
        $sqlQuery->set($restaurantplaystationplay->moveDuration);
        $sqlQuery->setNumber($restaurantplaystationplay->oldPsPlayid);
        $sqlQuery->setNumber($restaurantplaystationplay->startPrice);
        $sqlQuery->setNumber((float) $restaurantplaystationplay->cardPayed);
        $sqlQuery->setNumber((float) $restaurantplaystationplay->cashPayed);
        $sqlQuery->setNumber((int) $restaurantplaystationplay->psClientCardId);
        $sqlQuery->setNumber((int) $restaurantplaystationplay->priceIs);
        $sqlQuery->setNumber((float) $restaurantplaystationplay->hourPriceMulti);
        $sqlQuery->setNumber((int) $restaurantplaystationplay->allMovesUnitedSellBillId);

        $id = $this->executeInsert($sqlQuery);
        $restaurantplaystationplay->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RestaurantplaystationplayMySql restaurantplaystationplay
     */
    public function update($restaurantplaystationplay) {
        $sql = 'UPDATE restaurantplaystationplay SET playstationid = ?, hourPrice = ?, startsysDate = ?, endsysDate = ?, duration = ?, note = ?, totalPrice = ?, discount = ?, tax = ?, netPrice = ?, payed = ?, finished = ?, sellBillId = ?, userId = ?, sysdate = ?, del = ?, reservationType = ?, reservationHours = ?, reservationMinutes = ?, reservationEndDateTime = ?,moveStartSysDate = ?,moveDuration = ?,oldPsPlayid=?,startPrice=?,cardPayed = ?,cashPayed = ?,psClientCardId = ?,priceIs=?,hourPriceMulti=?,allMovesUnitedSellBillId=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($restaurantplaystationplay->playstationid);
        $sqlQuery->set($restaurantplaystationplay->hourPrice);
        $sqlQuery->set($restaurantplaystationplay->startsysDate);
        $sqlQuery->set($restaurantplaystationplay->endsysDate);
        $sqlQuery->set($restaurantplaystationplay->duration);
        $sqlQuery->setString2($restaurantplaystationplay->note);
        $sqlQuery->set($restaurantplaystationplay->totalPrice);
        $sqlQuery->set($restaurantplaystationplay->discount);
        $sqlQuery->set($restaurantplaystationplay->tax);
        $sqlQuery->set($restaurantplaystationplay->netPrice);
        $sqlQuery->set($restaurantplaystationplay->payed);
        $sqlQuery->setNumber($restaurantplaystationplay->finished);
        $sqlQuery->setNumber($restaurantplaystationplay->sellBillId);
        $sqlQuery->setNumber($restaurantplaystationplay->userId);
        $sqlQuery->set($restaurantplaystationplay->sysdate);
        $sqlQuery->setNumber($restaurantplaystationplay->del);
        $sqlQuery->setNumber($restaurantplaystationplay->reservationType);
        $sqlQuery->setNumber($restaurantplaystationplay->reservationHours);
        $sqlQuery->setNumber($restaurantplaystationplay->reservationMinutes);
        $sqlQuery->set($restaurantplaystationplay->reservationEndDateTime);
        $sqlQuery->set($restaurantplaystationplay->moveStartSysDate);
        $sqlQuery->set($restaurantplaystationplay->moveDuration);
        $sqlQuery->setNumber($restaurantplaystationplay->oldPsPlayid);
        $sqlQuery->setNumber($restaurantplaystationplay->startPrice);
        $sqlQuery->setNumber((float) $restaurantplaystationplay->cardPayed);
        $sqlQuery->setNumber((float) $restaurantplaystationplay->cashPayed);
        $sqlQuery->setNumber((int) $restaurantplaystationplay->psClientCardId);
        $sqlQuery->setNumber((int) $restaurantplaystationplay->priceIs);
        $sqlQuery->setNumber((float) $restaurantplaystationplay->hourPriceMulti);
        $sqlQuery->setNumber((int) $restaurantplaystationplay->allMovesUnitedSellBillId);

        $sqlQuery->setNumber($restaurantplaystationplay->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM restaurantplaystationplay';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByPlaystationid($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE playstationid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByHourPrice($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE hourPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStartsysDate($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE startsysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEndsysDate($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE endsysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDuration($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE duration = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotalPrice($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE totalPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscount($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE discount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTax($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE tax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNetPrice($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE netPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPayed($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE payed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByFinished($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE finished = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellBillId($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE sellBillId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReservationType($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE reservationType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReservationHours($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE reservationHours = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReservationMinutes($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE reservationMinutes = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReservationEndDateTime($value) {
        $sql = 'SELECT * FROM restaurantplaystationplay WHERE reservationEndDateTime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByPlaystationid($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE playstationid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByHourPrice($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE hourPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStartsysDate($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE startsysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEndsysDate($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE endsysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDuration($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE duration = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotalPrice($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE totalPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscount($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE discount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTax($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE tax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNetPrice($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE netPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPayed($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE payed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByFinished($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE finished = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellBillId($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE sellBillId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReservationType($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE reservationType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReservationHours($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE reservationHours = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReservationMinutes($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE reservationMinutes = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReservationEndDateTime($value) {
        $sql = 'DELETE FROM restaurantplaystationplay WHERE reservationEndDateTime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RestaurantplaystationplayMySql
     */
    protected function readRow($row) {
        $restaurantplaystationplay = new Restaurantplaystationplay();

        $restaurantplaystationplay->id = $row['id'];
        $restaurantplaystationplay->playstationid = $row['playstationid'];
        $restaurantplaystationplay->hourPrice = $row['hourPrice'];
        $restaurantplaystationplay->startsysDate = $row['startsysDate'];
        $restaurantplaystationplay->endsysDate = $row['endsysDate'];
        $restaurantplaystationplay->duration = $row['duration'];
        $restaurantplaystationplay->note = $row['note'];
        $restaurantplaystationplay->totalPrice = $row['totalPrice'];
        $restaurantplaystationplay->discount = $row['discount'];
        $restaurantplaystationplay->tax = $row['tax'];
        $restaurantplaystationplay->netPrice = $row['netPrice'];
        $restaurantplaystationplay->payed = $row['payed'];
        $restaurantplaystationplay->finished = $row['finished'];
        $restaurantplaystationplay->sellBillId = $row['sellBillId'];
        $restaurantplaystationplay->userId = $row['userId'];
        $restaurantplaystationplay->sysdate = $row['sysdate'];
        $restaurantplaystationplay->del = $row['del'];
        $restaurantplaystationplay->reservationType = $row['reservationType'];
        $restaurantplaystationplay->reservationHours = $row['reservationHours'];
        $restaurantplaystationplay->reservationMinutes = $row['reservationMinutes'];
        $restaurantplaystationplay->reservationEndDateTime = $row['reservationEndDateTime'];
        $restaurantplaystationplay->moveStartSysDate = $row['moveStartSysDate'];
        $restaurantplaystationplay->moveDuration = $row['moveDuration'];
        $restaurantplaystationplay->oldPsPlayid = $row['oldPsPlayid'];
        $restaurantplaystationplay->startPrice = $row['startPrice'];
        $restaurantplaystationplay->cardPayed = $row['cardPayed'];
        $restaurantplaystationplay->cashPayed = $row['cashPayed'];
        $restaurantplaystationplay->psClientCardId = $row['psClientCardId'];
        $restaurantplaystationplay->priceIs = $row['priceIs'];
        $restaurantplaystationplay->hourPriceMulti = $row['hourPriceMulti'];
        $restaurantplaystationplay->allMovesUnitedSellBillId = $row['allMovesUnitedSellBillId'];
        //
        $restaurantplaystationplay->serviceId = $row['serviceId'];
        $restaurantplaystationplay->deviceIdentification = $row['deviceIdentification'];
        $restaurantplaystationplay->subDeviceIdentification = $row['subDeviceIdentification'];
        $restaurantplaystationplay->useSubIdentification = $row['useSubIdentification'];
        $restaurantplaystationplay->tableId = $row['tableId'];
        $restaurantplaystationplay->name = $row['name'];

        return $restaurantplaystationplay;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RestaurantplaystationplayMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>