<?php

/**
 * Class that operate on table 'sellbill'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class SellbillMySqlDAO implements SellbillDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SellbillMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sellbill WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sellbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sellbill ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sellbill primary key
     */
    public function delete($sellbillid) {
        $sql = 'DELETE FROM sellbill WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SellbillMySql sellbill
     */
    public function insert($sellbill) {
        $sql = 'INSERT INTO sellbill (sellbilldate, sellbillserial, sellbillclientid, sellbilltotaldeptbefor, sellbilltotaldeptafter, sellbilldiscount, sellbilldiscounttype, sellbilltotalbill, sellbillaftertotalbill, sellbilltotalpayed, sellbillfinalbill, sellbillstoreid, sellbillsysdate,comment, userid, conditions, sellbillclientname, sellbillsaveid, sellbildirectpayment, billnameid, sellerid, tempclientName, sellQuantity,tax ,carnumber, cartype, carchase, carmotor,costcenterid,dailyentryid,obygyVisitId,onlineOrderId,delbyuserid,delivery,totalafterdelivery,billReservation,billReservationDate,webApiId,visaAccountId,cashPayed,visaPayed,isBankAccountTransfer,extraDiscountPer,extraDiscountVal,taxOfDiscountPer,taxOfDiscountVal,taxBillNumber,collectionType,collectionDate,qrerpid,qrerpids,autoSaveFlag,ereason,estatus,epdf,obgyBillType,billoperationid,datestarting,pricetype,currencyId,knownwayId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellbill->sellbilldate);
        $sqlQuery->set($sellbill->sellbillserial);
        $sqlQuery->setNumber($sellbill->sellbillclientid);
        $sqlQuery->set($sellbill->sellbilltotaldeptbefor);
        $sqlQuery->set($sellbill->sellbilltotaldeptafter);
        $sqlQuery->set($sellbill->sellbilldiscount);
        $sqlQuery->setNumber($sellbill->sellbilldiscounttype);
        $sqlQuery->set($sellbill->sellbilltotalbill);
        $sqlQuery->set($sellbill->sellbillaftertotalbill);
        $sqlQuery->set($sellbill->sellbilltotalpayed);
        $sqlQuery->set($sellbill->sellbillfinalbill);
        $sqlQuery->setNumber($sellbill->sellbillstoreid);
        $sqlQuery->set($sellbill->sellbillsysdate);
        $sqlQuery->set($sellbill->comment);
        $sqlQuery->setNumber($sellbill->userid);
        $sqlQuery->setNumber($sellbill->conditions);
        $sqlQuery->set($sellbill->sellbillclientname);
        $sqlQuery->setNumber($sellbill->sellbillsaveid);
        $sqlQuery->setNumber($sellbill->sellbildirectpayment);
        $sqlQuery->setNumber($sellbill->billnameid);
        $sqlQuery->setNumber($sellbill->sellerid);
        $sqlQuery->set($sellbill->tempclientName);
        $sqlQuery->setNumber($sellbill->sellQuantity);

        $sqlQuery->set($sellbill->tax);
        $sqlQuery->set($sellbill->carnumber);
        $sqlQuery->set($sellbill->cartype);
        $sqlQuery->set($sellbill->carchase);
        $sqlQuery->set($sellbill->carmotor);

        $sqlQuery->setNumber($sellbill->costcenterid);
        $sqlQuery->set($sellbill->dailyentryid);
        $sqlQuery->setNumber((int) $sellbill->obygyVisitId);
        $sqlQuery->setNumber((int) $sellbill->onlineOrderId);
        $sqlQuery->setNumber((int) $sellbill->delbyuserid);
        $sqlQuery->setNumber((int) $sellbill->delivery);
        $sqlQuery->setNumber((int) $sellbill->totalafterdelivery);
        $sqlQuery->setNumber((int) $sellbill->billReservation);
        $sqlQuery->set($sellbill->billReservationDate);
        $sqlQuery->setNumber((int) $sellbill->webApiId);
        $sqlQuery->setNumber((int) $sellbill->visaAccountId);
        $sqlQuery->setNumber((float) $sellbill->cashPayed);
        $sqlQuery->setNumber((float) $sellbill->visaPayed);
        $sqlQuery->setNumber((int) $sellbill->isBankAccountTransfer);
        $sqlQuery->setNumber((float) $sellbill->extraDiscountPer);
        $sqlQuery->setNumber((float) $sellbill->extraDiscountVal);
        $sqlQuery->setNumber((float) $sellbill->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $sellbill->taxOfDiscountVal);
        $sqlQuery->setNumber((int) $sellbill->taxBillNumber);
        $sqlQuery->setNumber((int) $sellbill->collectionType);
        $sqlQuery->set($sellbill->collectionDate);
        $sqlQuery->set($sellbill->qrerpid);
        $sqlQuery->set($sellbill->qrerpids);
        $sqlQuery->setNumber((int) $sellbill->autoSaveFlag);
        $sqlQuery->set($sellbill->ereason);
        $sqlQuery->setNumber((int) $sellbill->estatus);
        $sqlQuery->set($sellbill->epdf);
        $sqlQuery->setNumber((int) $sellbill->obgyBillType);
        $sqlQuery->setNumber((int) $sellbill->billoperationid);
        $sqlQuery->set($sellbill->datestarting);
        $sqlQuery->setNumber((int) $sellbill->pricetype);
        $sqlQuery->setNumber((int) $sellbill->currencyId);
        $sqlQuery->setNumber((int) $sellbill->knownwayId);



        $id = $this->executeInsert($sqlQuery);
        $sellbill->sellbillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SellbillMySql sellbill
     */
    public function update($sellbill) {
        $sql = 'UPDATE sellbill SET sellbilldate = ?, sellbillserial = ?, sellbillclientid = ?, sellbilltotaldeptbefor = ?, sellbilltotaldeptafter = ?, sellbilldiscount = ?, sellbilldiscounttype = ?, sellbilltotalbill = ?, sellbillaftertotalbill = ?, sellbilltotalpayed = ?, sellbillfinalbill = ?, sellbillstoreid = ?, sellbillsysdate = ?,comment = ?, userid = ?, conditions = ?, sellbillclientname = ?, sellbillsaveid = ?, sellbildirectpayment = ?, billnameid = ?, sellerid = ?, tempclientName = ?, sellQuantity = ? , dailyentryid = ?,obygyVisitId = ?,onlineOrderId = ?,delbyuserid = ?,delivery = ?,totalafterdelivery = ?,billReservation=?,billReservationDate=?,visaAccountId = ?,cashPayed = ?,visaPayed = ?,isBankAccountTransfer = ?,extraDiscountPer=?,extraDiscountVal=?,taxOfDiscountPer=?,taxOfDiscountVal=?,taxBillNumber=?,collectionType = ?,collectionDate=?,qrerpid=?,qrerpids=?,autoSaveFlag=?,ereason=?,estatus=?,epdf=?,obgyBillType=?,billoperationid=?,datestarting=?,pricetype=?,currencyId=?,knownwayId=? WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellbill->sellbilldate);
        $sqlQuery->set($sellbill->sellbillserial);
        $sqlQuery->setNumber($sellbill->sellbillclientid);
        $sqlQuery->set($sellbill->sellbilltotaldeptbefor);
        $sqlQuery->set($sellbill->sellbilltotaldeptafter);
        $sqlQuery->set($sellbill->sellbilldiscount);
        $sqlQuery->setNumber($sellbill->sellbilldiscounttype);
        $sqlQuery->set($sellbill->sellbilltotalbill);
        $sqlQuery->set($sellbill->sellbillaftertotalbill);
        $sqlQuery->set($sellbill->sellbilltotalpayed);
        $sqlQuery->set($sellbill->sellbillfinalbill);
        $sqlQuery->setNumber($sellbill->sellbillstoreid);
        $sqlQuery->set($sellbill->sellbillsysdate);
        $sqlQuery->set($sellbill->comment);
        $sqlQuery->setNumber($sellbill->userid);
        $sqlQuery->setNumber($sellbill->conditions);
        $sqlQuery->set($sellbill->sellbillclientname);
        $sqlQuery->setNumber($sellbill->sellbillsaveid);
        $sqlQuery->setNumber($sellbill->sellbildirectpayment);
        $sqlQuery->setNumber($sellbill->billnameid);
        $sqlQuery->setNumber($sellbill->sellerid);
        $sqlQuery->set($sellbill->tempclientName);
        $sqlQuery->setNumber($sellbill->sellQuantity);
        $sqlQuery->set($sellbill->dailyentryid);
        $sqlQuery->setNumber((int) $sellbill->obygyVisitId);
        $sqlQuery->setNumber((int) $sellbill->onlineOrderId);
        $sqlQuery->setNumber((int) $sellbill->delbyuserid);
        $sqlQuery->setNumber((int) $sellbill->delivery);
        $sqlQuery->setNumber((int) $sellbill->totalafterdelivery);
        $sqlQuery->setNumber((int) $sellbill->billReservation);
        $sqlQuery->set($sellbill->billReservationDate);
        $sqlQuery->setNumber((int) $sellbill->visaAccountId);
        $sqlQuery->setNumber((float) $sellbill->cashPayed);
        $sqlQuery->setNumber((float) $sellbill->visaPayed);
        $sqlQuery->setNumber((int) $sellbill->isBankAccountTransfer);
        $sqlQuery->setNumber((float) $sellbill->extraDiscountPer);
        $sqlQuery->setNumber((float) $sellbill->extraDiscountVal);
        $sqlQuery->setNumber((float) $sellbill->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $sellbill->taxOfDiscountVal);
        $sqlQuery->setNumber((int) $sellbill->taxBillNumber);
        $sqlQuery->setNumber((int) $sellbill->collectionType);
        $sqlQuery->set($sellbill->collectionDate);
        $sqlQuery->set($sellbill->qrerpid);
        $sqlQuery->set($sellbill->qrerpids);
        $sqlQuery->setNumber((int) $sellbill->autoSaveFlag);
        $sqlQuery->set($sellbill->ereason);
        $sqlQuery->setNumber((int) $sellbill->estatus);
        $sqlQuery->set($sellbill->epdf);
        $sqlQuery->set((int) $sellbill->obgyBillType);
        $sqlQuery->set((int) $sellbill->billoperationid);
        $sqlQuery->set($sellbill->datestarting);
        $sqlQuery->setNumber((int) $sellbill->pricetype);
        $sqlQuery->setNumber((int) $sellbill->currencyId);
        $sqlQuery->setNumber((int) $sellbill->knownwayId);



        $sqlQuery->setNumber($sellbill->sellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sellbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySellbilldate($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillserial($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillclientid($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotaldeptbefor($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotaldeptafter($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldiscount($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldiscounttype($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotalbill($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillaftertotalbill($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotalpayed($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillfinalbill($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillstoreid($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillsysdate($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM sellbill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM sellbill WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillclientname($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillsaveid($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbildirectpayment($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillnameid($value) {
        $sql = 'SELECT * FROM sellbill WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellerid($value) {
        $sql = 'SELECT * FROM sellbill WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySellbilldate($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillserial($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillclientid($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotaldeptbefor($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotaldeptafter($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldiscount($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldiscounttype($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotalbill($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillaftertotalbill($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotalpayed($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillfinalbill($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillstoreid($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillsysdate($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM sellbill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM sellbill WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillclientname($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillsaveid($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbildirectpayment($value) {
        $sql = 'DELETE FROM sellbill WHERE sellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillnameid($value) {
        $sql = 'DELETE FROM sellbill WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellerid($value) {
        $sql = 'DELETE FROM sellbill WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SellbillMySql
     */
    protected function readRow($row) {
        $sellbill = new Sellbill();

        $sellbill->sellbillid = isset($row['sellbillid']) ? $row['sellbillid'] : '';
        $sellbill->sellbilldate = isset($row['sellbilldate']) ? $row['sellbilldate'] : '';
        $sellbill->sellbillserial = isset($row['sellbillserial']) ? $row['sellbillserial'] : '';
        $sellbill->sellbillclientid = isset($row['sellbillclientid']) ? $row['sellbillclientid'] : '';
        $sellbill->sellbilltotaldeptbefor = isset($row['sellbilltotaldeptbefor']) ? $row['sellbilltotaldeptbefor'] : '';
        $sellbill->sellbilltotaldeptafter = isset($row['sellbilltotaldeptafter']) ? $row['sellbilltotaldeptafter'] : '';
        $sellbill->sellbilldiscount = isset($row['sellbilldiscount']) ? $row['sellbilldiscount'] : '';
        $sellbill->sellbilldiscounttype = isset($row['sellbilldiscounttype']) ? $row['sellbilldiscounttype'] : '';
        $sellbill->sellbilltotalbill = isset($row['sellbilltotalbill']) ? $row['sellbilltotalbill'] : '';
        $sellbill->sellbillaftertotalbill = isset($row['sellbillaftertotalbill']) ? $row['sellbillaftertotalbill'] : '';
        $sellbill->sellbilltotalpayed = isset($row['sellbilltotalpayed']) ? $row['sellbilltotalpayed'] : '';
        $sellbill->sellbillfinalbill = isset($row['sellbillfinalbill']) ? $row['sellbillfinalbill'] : '';
        $sellbill->sellbillstoreid = isset($row['sellbillstoreid']) ? $row['sellbillstoreid'] : '';
        $sellbill->sellbillsysdate = isset($row['sellbillsysdate']) ? $row['sellbillsysdate'] : '';
        $sellbill->comment = isset($row['comment']) ? $row['comment'] : '';
        $sellbill->userid = isset($row['userid']) ? $row['userid'] : '';
        $sellbill->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $sellbill->sellbillclientname = isset($row['sellbillclientname']) ? $row['sellbillclientname'] : '';
        $sellbill->sellbillsaveid = isset($row['sellbillsaveid']) ? $row['sellbillsaveid'] : '';
        $sellbill->sellbildirectpayment = isset($row['sellbildirectpayment']) ? $row['sellbildirectpayment'] : '';
        $sellbill->billnameid = isset($row['billnameid']) ? $row['billnameid'] : '';
        $sellbill->sellerid = isset($row['sellerid']) ? $row['sellerid'] : '';
        $sellbill->tempclientName = isset($row['tempclientName']) ? $row['tempclientName'] : '';
        $sellbill->sellQuantity = isset($row['sellQuantity']) ? $row['sellQuantity'] : '';

        $sellbill->deletedsellid = isset($row['deletedsellid']) ? $row['deletedsellid'] : '';
        $sellbill->controlname = isset($row['controlname']) ? $row['controlname'] : '';
        $sellbill->tax = isset($row['tax']) ? $row['tax'] : '';
        $sellbill->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $sellbill->obygyVisitId = isset($row['obygyVisitId']) ? $row['obygyVisitId'] : '';
        $sellbill->onlineOrderId = isset($row['onlineOrderId']) ? $row['onlineOrderId'] : '';
        $sellbill->areaName = isset($row['areaName']) ? $row['areaName'] : '';
        $sellbill->governmentname = isset($row['governmentname']) ? $row['governmentname'] : '';



        $sellbill->carnumber = isset($row['carnumber']) ? $row['carnumber'] : '';
        $sellbill->cartype = isset($row['cartype']) ? $row['cartype'] : '';
        $sellbill->carchase = isset($row['carchase']) ? $row['carchase'] : '';
        $sellbill->carmotor = isset($row['carmotor']) ? $row['carmotor'] : '';
        //required
        $sellbill->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $sellbill->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $sellbill->savename = isset($row['savename']) ? $row['savename'] : '';
        $sellbill->employeename = isset($row['employeename']) ? $row['employeename'] : '';
        $sellbill->useremployeename = isset($row['useremployeename']) ? $row['useremployeename'] : '';
        $sellbill->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';
        $sellbill->productBuyPrice = isset($row['productBuyPrice']) ? $row['productBuyPrice'] : '';
        $sellbill->sellbilldetailprice = isset($row['sellbilldetailprice']) ? $row['sellbilldetailprice'] : '';
        $sellbill->sellbilldetailquantity = isset($row['sellbilldetailquantity']) ? $row['sellbilldetailquantity'] : '';
        $sellbill->theDate = isset($row['theDate']) ? $row['theDate'] : '';
        $sellbill->allGenTotal = isset($row['allGenTotal']) ? $row['allGenTotal'] : '';
        $sellbill->totaldiscount = isset($row['totaldiscount']) ? $row['totaldiscount'] : '';
        $sellbill->newSellbillidAfterEdit = isset($row['newSellbillidAfterEdit']) ? $row['newSellbillidAfterEdit'] : '';
        $sellbill->visaAccountId = isset($row['visaAccountId']) ? $row['visaAccountId'] : '';
        $sellbill->cashPayed = isset($row['cashPayed']) ? $row['cashPayed'] : '';
        $sellbill->visaPayed = isset($row['visaPayed']) ? $row['visaPayed'] : '';
        $sellbill->isBankAccountTransfer = isset($row['isBankAccountTransfer']) ? $row['isBankAccountTransfer'] : '';
        $sellbill->extraDiscountPer = isset($row['extraDiscountPer']) ? $row['extraDiscountPer'] : '';
        $sellbill->extraDiscountVal = isset($row['extraDiscountVal']) ? $row['extraDiscountVal'] : '';
        $sellbill->taxOfDiscountPer = isset($row['taxOfDiscountPer']) ? $row['taxOfDiscountPer'] : '';
        $sellbill->taxOfDiscountVal = isset($row['taxOfDiscountVal']) ? $row['taxOfDiscountVal'] : '';
        $sellbill->taxBillNumber = isset($row['taxBillNumber']) ? $row['taxBillNumber'] : '';
        $sellbill->collectionType = isset($row['collectionType']) ? $row['collectionType'] : '';
        $sellbill->collectionDate = isset($row['collectionDate']) ? $row['collectionDate'] : '';

        //m7md
        $sellbill->sumQuantity = isset($row['sumQuantity']) ? $row['sumQuantity'] : '';
        $sellbill->sumTotalbill = isset($row['sumTotalbill']) ? $row['sumTotalbill'] : '';
        $sellbill->sumDiscount = isset($row['sumDiscount']) ? $row['sumDiscount'] : '';
        $sellbill->productid = isset($row['productid']) ? $row['productid'] : '';
        $sellbill->productName = isset($row['productName']) ? $row['productName'] : '';
        $sellbill->sellbilltotalAllPayed = isset($row['sellbilltotalAllPayed']) ? $row['sellbilltotalAllPayed'] : '';
        $sellbill->username = isset($row['username']) ? $row['username'] : '';
        $sellbill->pricetype = isset($row['pricetype']) ? $row['pricetype'] : '';
        $sellbill->currencyId = isset($row['currencyId']) ? $row['currencyId'] : '';
        $sellbill->clientdebt = isset($row['clientdebt']) ? $row['clientdebt'] : '';

        $sellbill->countsellbill = isset($row['countsellbill']) ? $row['countsellbill'] : '';
        $sellbill->delbyuserid = isset($row['delbyuserid']) ? $row['delbyuserid'] : '';
        $sellbill->delbyusername = isset($row['delbyusername']) ? $row['delbyusername'] : '';
        $sellbill->sellbilldetailproductid = isset($row['sellbilldetailproductid']) ? $row['sellbilldetailproductid'] : '';
        $sellbill->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $sellbill->colorid = isset($row['colorid']) ? $row['colorid'] : '';

        $sellbill->reviewType = isset($row['reviewType']) ? $row['reviewType'] : '';
        $sellbill->lastReviewType = isset($row['lastReviewType']) ? $row['lastReviewType'] : '';
        $sellbill->lastReviewUser = isset($row['lastReviewUser']) ? $row['lastReviewUser'] : '';
        $sellbill->lastReviewDateTime = isset($row['lastReviewDateTime']) ? $row['lastReviewDateTime'] : '';

        $sellbill->delivery = isset($row['delivery']) ? $row['delivery'] : '';
        $sellbill->totalafterdelivery = isset($row['totalafterdelivery']) ? $row['totalafterdelivery'] : '';
        $sellbill->billReservation = isset($row['billReservation']) ? $row['billReservation'] : '';
        $sellbill->billReservationDate = isset($row['billReservationDate']) ? $row['billReservationDate'] : '';
        $sellbill->webApiId = isset($row['webApiId']) ? $row['webApiId'] : '';
        $sellbill->shippingDate = isset($row['shippingDate']) ? $row['shippingDate'] : '';
        $sellbill->parcode = isset($row['parcode']) ? $row['parcode'] : '';
        $sellbill->qrerpid = isset($row['qrerpid']) ? $row['qrerpid'] : '';
        $sellbill->qrerpids = isset($row['qrerpids']) ? $row['qrerpids'] : '';
        $sellbill->taxnumber = isset($row['taxnumber']) ? $row['taxnumber'] : '';
        $sellbill->autoSaveFlag = isset($row['autoSaveFlag']) ? $row['autoSaveFlag'] : '';
        $sellbill->ereason = isset($row['ereason']) ? $row['ereason'] : '';
        $sellbill->estatus = isset($row['estatus']) ? $row['estatus'] : '';
        $sellbill->epdf = isset($row['epdf']) ? $row['epdf'] : '';
        $sellbill->obgyBillType = isset($row['obgyBillType']) ? $row['obgyBillType'] : '';
        $sellbill->billoperationid = isset($row['billoperationid']) ? $row['billoperationid'] : '';
        $sellbill->datestarting = isset($row['datestarting']) ? $row['datestarting'] : '';
        $sellbill->knownwayId = isset($row['knownwayId']) ? $row['knownwayId'] : '';




        return $sellbill;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SellbillMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>
