<?php

/**
 * Class that operate on table 'settingoperation'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @operationDate: 2014-04-01 11:09
 */
class SettingoperationMySqlDAO implements SettingoperationDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SettingoperationMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM settingoperation WHERE settingOperationID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM settingoperation';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM settingoperation ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param settingoperation primary key
     */
    public function delete($settingOperationID) {
        $sql = 'DELETE FROM settingoperation WHERE settingOperationID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($settingOperationID);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SettingoperationMySql settingoperation
     */
    public function insert($settingoperation) {
        $sql = 'INSERT INTO settingoperation (settingOperationName, workStationID, realTime, assetesID, workersNo, conditions, userID, operationDate,	operationType) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($settingoperation->settingOperationName);
        $sqlQuery->setNumber($settingoperation->workStationID);
        $sqlQuery->setNumber($settingoperation->realTime);
        $sqlQuery->set($settingoperation->assetesID);
        $sqlQuery->setNumber($settingoperation->workersNo);
        $sqlQuery->setNumber($settingoperation->conditions);
        $sqlQuery->setNumber($settingoperation->userID);
        $sqlQuery->set($settingoperation->operationDate);
        $sqlQuery->set($settingoperation->operationType);

        $id = $this->executeInsert($sqlQuery);
        $settingoperation->settingOperationID = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SettingoperationMySql settingoperation
     */
    public function update($settingoperation) {
        $sql = 'UPDATE settingoperation SET settingOperationName = ?, workStationID = ?, realTime = ?, assetesID = ?, workersNo = ?, conditions = ?, userID = ?, operationDate = ? WHERE settingOperationID = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($settingoperation->settingOperationName);
        $sqlQuery->setNumber($settingoperation->workStationID);
        $sqlQuery->setNumber($settingoperation->realTime);
        $sqlQuery->setNumber($settingoperation->assetesID);
        $sqlQuery->setNumber($settingoperation->workersNo);
        $sqlQuery->setNumber($settingoperation->conditions);
        $sqlQuery->setNumber($settingoperation->userID);
        $sqlQuery->set($settingoperation->operationDate);



        $sqlQuery->setNumber($settingoperation->settingOperationID);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM settingoperation';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySettingOperationName($value) {
        $sql = 'SELECT * FROM settingoperation WHERE settingOperationName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWorkStationID($value) {
        $sql = 'SELECT * FROM settingoperation WHERE workStationID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRealTime($value) {
        $sql = 'SELECT * FROM settingoperation WHERE realTime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAssetesID($value) {
        $sql = 'SELECT * FROM settingoperation WHERE assetesID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWorkersNo($value) {
        $sql = 'SELECT * FROM settingoperation WHERE workersNo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM settingoperation WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserID($value) {
        $sql = 'SELECT * FROM settingoperation WHERE userID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDate($value) {
        $sql = 'SELECT * FROM settingoperation WHERE operationDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySettingOperationName($value) {
        $sql = 'DELETE FROM settingoperation WHERE settingOperationName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWorkStationID($value) {
        $sql = 'DELETE FROM settingoperation WHERE workStationID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRealTime($value) {
        $sql = 'DELETE FROM settingoperation WHERE realTime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAssetesID($value) {
        $sql = 'DELETE FROM settingoperation WHERE assetesID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWorkersNo($value) {
        $sql = 'DELETE FROM settingoperation WHERE workersNo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM settingoperation WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserID($value) {
        $sql = 'DELETE FROM settingoperation WHERE userID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDate($value) {
        $sql = 'DELETE FROM settingoperation WHERE operationDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SettingoperationMySql
     */
    protected function readRow($row) {
        $settingoperation = new Settingoperation();

        $settingoperation->settingOperationID = isset($row['settingOperationID']) ? $row['settingOperationID'] : '';
        $settingoperation->settingOperationName = isset($row['settingOperationName']) ? $row['settingOperationName'] : '';
        $settingoperation->workStationID = isset($row['workStationID']) ? $row['workStationID'] : '';
        $settingoperation->realTime = isset($row['realTime']) ? $row['realTime'] : '';
        $settingoperation->assetesID = isset($row['assetesID']) ? $row['assetesID'] : '';
        $settingoperation->workersNo = isset($row['workersNo']) ? $row['workersNo'] : '';
        $settingoperation->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $settingoperation->userID = isset($row['userID']) ? $row['userID'] : '';
        $settingoperation->operationDate = isset($row['operationDate']) ? $row['operationDate'] : '';
        $settingoperation->workname = isset($row['workname']) ? $row['workname'] : '';
        $settingoperation->assetsName = isset($row['assetsName']) ? $row['assetsName'] : '';
        $settingoperation->operationType = isset($row['operationType']) ? $row['operationType'] : '';

        return $settingoperation;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SettingoperationMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>