<?php
/**
 * Class that operate on table 'sizecolor'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-08-18 15:09
 */
class SizecolorMySqlDAO implements SizecolorDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return SizecolorMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM sizecolor WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM sizecolor';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM sizecolor ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param sizecolor primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM sizecolor WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param SizecolorMySql sizecolor
 	 */
	public function insert($sizecolor){
		$sql = 'INSERT INTO sizecolor (name, type, userid, conditions, sysdate) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($sizecolor->name);
		$sqlQuery->setNumber($sizecolor->type);
		$sqlQuery->setNumber($sizecolor->userid);
		$sqlQuery->setNumber($sizecolor->conditions);
		$sqlQuery->set($sizecolor->sysdate);

		$id = $this->executeInsert($sqlQuery);	
		$sizecolor->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param SizecolorMySql sizecolor
 	 */
	public function update($sizecolor){
		$sql = 'UPDATE sizecolor SET name = ?, type = ?, userid = ?, conditions = ?, sysdate = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($sizecolor->name);
		$sqlQuery->setNumber($sizecolor->type);
		$sqlQuery->setNumber($sizecolor->userid);
		$sqlQuery->setNumber($sizecolor->conditions);
		$sqlQuery->set($sizecolor->sysdate);

		$sqlQuery->setNumber($sizecolor->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM sizecolor';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByName($value){
		$sql = 'SELECT * FROM sizecolor WHERE name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByType($value){
		$sql = 'SELECT * FROM sizecolor WHERE type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM sizecolor WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM sizecolor WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM sizecolor WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByName($value){
		$sql = 'DELETE FROM sizecolor WHERE name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByType($value){
		$sql = 'DELETE FROM sizecolor WHERE type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM sizecolor WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM sizecolor WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM sizecolor WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return SizecolorMySql 
	 */
	protected function readRow($row){
		$sizecolor = new Sizecolor();
		
		$sizecolor->id = $row['id'];
		$sizecolor->name = $row['name'];
		$sizecolor->type = $row['type'];
		$sizecolor->userid = $row['userid'];
		$sizecolor->conditions = $row['conditions'];
		$sizecolor->sysdate = $row['sysdate'];
                //
		$sizecolor->scExcelid = $row['scExcelid'];

		return $sizecolor;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return SizecolorMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>