<?php

/**
 * Class that operate on table 'supplieropenexchangeorclosing'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-07-21 12:59
 */
class SupplieropenexchangeorclosingMySqlDAO implements SupplieropenexchangeorclosingDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SupplieropenexchangeorclosingMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM supplieropenexchangeorclosing WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM supplieropenexchangeorclosing';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM supplieropenexchangeorclosing ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param supplieropenexchangeorclosing primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM supplieropenexchangeorclosing WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SupplieropenexchangeorclosingMySql supplieropenexchangeorclosing
     */
    public function insert($supplieropenexchangeorclosing) {
        $sql = 'INSERT INTO supplieropenexchangeorclosing (thetype, supplieropenid, saveid, assetorexpense, assetorexpenseid, val, dailyentryid, note, userid, sysdate, del) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($supplieropenexchangeorclosing->thetype);
        $sqlQuery->setNumber($supplieropenexchangeorclosing->supplieropenid);
        $sqlQuery->setNumber($supplieropenexchangeorclosing->saveid);
        $sqlQuery->setNumber($supplieropenexchangeorclosing->assetorexpense);
        $sqlQuery->setNumber($supplieropenexchangeorclosing->assetorexpenseid);
        $sqlQuery->set($supplieropenexchangeorclosing->val);
        $sqlQuery->setNumber($supplieropenexchangeorclosing->dailyentryid);
        $sqlQuery->setString2($supplieropenexchangeorclosing->note);
        $sqlQuery->setNumber($supplieropenexchangeorclosing->userid);
        $sqlQuery->set($supplieropenexchangeorclosing->sysdate);
        $sqlQuery->setNumber($supplieropenexchangeorclosing->del);

        $id = $this->executeInsert($sqlQuery);
        $supplieropenexchangeorclosing->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SupplieropenexchangeorclosingMySql supplieropenexchangeorclosing
     */
    public function update($supplieropenexchangeorclosing) {
        $sql = 'UPDATE supplieropenexchangeorclosing SET thetype = ?, supplieropenid = ?, saveid = ?, assetorexpense = ?, assetorexpenseid = ?, val = ?, dailyentryid = ?, note = ?, userid = ?, sysdate = ?, del = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($supplieropenexchangeorclosing->thetype);
        $sqlQuery->setNumber($supplieropenexchangeorclosing->supplieropenid);
        $sqlQuery->setNumber($supplieropenexchangeorclosing->saveid);
        $sqlQuery->setNumber($supplieropenexchangeorclosing->assetorexpense);
        $sqlQuery->setNumber($supplieropenexchangeorclosing->assetorexpenseid);
        $sqlQuery->set($supplieropenexchangeorclosing->val);
        $sqlQuery->setNumber($supplieropenexchangeorclosing->dailyentryid);
        $sqlQuery->setString2($supplieropenexchangeorclosing->note);
        $sqlQuery->setNumber($supplieropenexchangeorclosing->userid);
        $sqlQuery->set($supplieropenexchangeorclosing->sysdate);
        $sqlQuery->setNumber($supplieropenexchangeorclosing->del);

        $sqlQuery->setNumber($supplieropenexchangeorclosing->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM supplieropenexchangeorclosing';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByThetype($value) {
        $sql = 'SELECT * FROM supplieropenexchangeorclosing WHERE thetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplieropenid($value) {
        $sql = 'SELECT * FROM supplieropenexchangeorclosing WHERE supplieropenid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveid($value) {
        $sql = 'SELECT * FROM supplieropenexchangeorclosing WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAssetorexpense($value) {
        $sql = 'SELECT * FROM supplieropenexchangeorclosing WHERE assetorexpense = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAssetorexpenseid($value) {
        $sql = 'SELECT * FROM supplieropenexchangeorclosing WHERE assetorexpenseid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByVal($value) {
        $sql = 'SELECT * FROM supplieropenexchangeorclosing WHERE val = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDailyentryid($value) {
        $sql = 'SELECT * FROM supplieropenexchangeorclosing WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM supplieropenexchangeorclosing WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM supplieropenexchangeorclosing WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM supplieropenexchangeorclosing WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM supplieropenexchangeorclosing WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByThetype($value) {
        $sql = 'DELETE FROM supplieropenexchangeorclosing WHERE thetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplieropenid($value) {
        $sql = 'DELETE FROM supplieropenexchangeorclosing WHERE supplieropenid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveid($value) {
        $sql = 'DELETE FROM supplieropenexchangeorclosing WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAssetorexpense($value) {
        $sql = 'DELETE FROM supplieropenexchangeorclosing WHERE assetorexpense = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAssetorexpenseid($value) {
        $sql = 'DELETE FROM supplieropenexchangeorclosing WHERE assetorexpenseid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByVal($value) {
        $sql = 'DELETE FROM supplieropenexchangeorclosing WHERE val = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDailyentryid($value) {
        $sql = 'DELETE FROM supplieropenexchangeorclosing WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM supplieropenexchangeorclosing WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM supplieropenexchangeorclosing WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM supplieropenexchangeorclosing WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM supplieropenexchangeorclosing WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SupplieropenexchangeorclosingMySql
     */
    protected function readRow($row) {
        $supplieropenexchangeorclosing = new Supplieropenexchangeorclosing();

        $supplieropenexchangeorclosing->id = $row['id'];
        $supplieropenexchangeorclosing->thetype = $row['thetype'];
        $supplieropenexchangeorclosing->supplieropenid = $row['supplieropenid'];
        $supplieropenexchangeorclosing->saveid = $row['saveid'];
        $supplieropenexchangeorclosing->assetorexpense = $row['assetorexpense'];
        $supplieropenexchangeorclosing->assetorexpenseid = $row['assetorexpenseid'];
        $supplieropenexchangeorclosing->val = $row['val'];
        $supplieropenexchangeorclosing->dailyentryid = $row['dailyentryid'];
        $supplieropenexchangeorclosing->note = $row['note'];
        $supplieropenexchangeorclosing->userid = $row['userid'];
        $supplieropenexchangeorclosing->sysdate = $row['sysdate'];
        $supplieropenexchangeorclosing->del = $row['del'];
        //
        $supplieropenexchangeorclosing->suppOpenName = $row['suppOpenName'];
        $supplieropenexchangeorclosing->savename = $row['savename'];
        $supplieropenexchangeorclosing->assetsName = $row['assetsName'];
        $supplieropenexchangeorclosing->expensestypename = $row['expensestypename'];

        return $supplieropenexchangeorclosing;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SupplieropenexchangeorclosingMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>