<?php
/**
 * Class that operate on table 'tamweenclientdetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-12-14 16:00
 */
class TamweenclientdetailMySqlDAO implements TamweenclientdetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TamweenclientdetailMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tamweenclientdetail WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tamweenclientdetail';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tamweenclientdetail ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tamweenclientdetail primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tamweenclientdetail WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TamweenclientdetailMySql tamweenclientdetail
 	 */
	public function insert($tamweenclientdetail){
		$sql = 'INSERT INTO tamweenclientdetail (clientid, noOfPersonsTamween, noOfPersonsDa3m, cardNum, cardPassword) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tamweenclientdetail->clientid);
		$sqlQuery->setNumber($tamweenclientdetail->noOfPersonsTamween);
		$sqlQuery->setNumber($tamweenclientdetail->noOfPersonsDa3m);
		$sqlQuery->set($tamweenclientdetail->cardNum);
		$sqlQuery->set($tamweenclientdetail->cardPassword);

		$id = $this->executeInsert($sqlQuery);	
		$tamweenclientdetail->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TamweenclientdetailMySql tamweenclientdetail
 	 */
	public function update($tamweenclientdetail){
		$sql = 'UPDATE tamweenclientdetail SET clientid = ?, noOfPersonsTamween = ?, noOfPersonsDa3m = ?, cardNum = ?, cardPassword = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tamweenclientdetail->clientid);
		$sqlQuery->setNumber($tamweenclientdetail->noOfPersonsTamween);
		$sqlQuery->setNumber($tamweenclientdetail->noOfPersonsDa3m);
		$sqlQuery->set($tamweenclientdetail->cardNum);
		$sqlQuery->set($tamweenclientdetail->cardPassword);

		$sqlQuery->setNumber($tamweenclientdetail->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tamweenclientdetail';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByClientid($value){
		$sql = 'SELECT * FROM tamweenclientdetail WHERE clientid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByNoOfPersonsTamween($value){
		$sql = 'SELECT * FROM tamweenclientdetail WHERE noOfPersonsTamween = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByNoOfPersonsDa3m($value){
		$sql = 'SELECT * FROM tamweenclientdetail WHERE noOfPersonsDa3m = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCardNum($value){
		$sql = 'SELECT * FROM tamweenclientdetail WHERE cardNum = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCardPassword($value){
		$sql = 'SELECT * FROM tamweenclientdetail WHERE cardPassword = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByClientid($value){
		$sql = 'DELETE FROM tamweenclientdetail WHERE clientid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByNoOfPersonsTamween($value){
		$sql = 'DELETE FROM tamweenclientdetail WHERE noOfPersonsTamween = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByNoOfPersonsDa3m($value){
		$sql = 'DELETE FROM tamweenclientdetail WHERE noOfPersonsDa3m = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCardNum($value){
		$sql = 'DELETE FROM tamweenclientdetail WHERE cardNum = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCardPassword($value){
		$sql = 'DELETE FROM tamweenclientdetail WHERE cardPassword = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TamweenclientdetailMySql 
	 */
	protected function readRow($row){
		$tamweenclientdetail = new Tamweenclientdetail();
		
		$tamweenclientdetail->id = $row['id'];
		$tamweenclientdetail->clientid = $row['clientid'];
		$tamweenclientdetail->noOfPersonsTamween = $row['noOfPersonsTamween'];
		$tamweenclientdetail->noOfPersonsDa3m = $row['noOfPersonsDa3m'];
		$tamweenclientdetail->cardNum = $row['cardNum'];
		$tamweenclientdetail->cardPassword = $row['cardPassword'];

		return $tamweenclientdetail;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TamweenclientdetailMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>