<?php

/**
 * Class that operate on table 'temreturnsellbilldetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-07-01 15:25
 */
class TemreturnsellbilldetailMySqlDAO implements TemreturnsellbilldetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return TemreturnsellbilldetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE returnsellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM temreturnsellbilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM temreturnsellbilldetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param temreturnsellbilldetail primary key
     */
    public function delete($returnsellbilldetailid) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE returnsellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($returnsellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param TemreturnsellbilldetailMySql temreturnsellbilldetail
     */
    public function insert($temreturnsellbilldetail) {
        $sql = 'INSERT INTO temreturnsellbilldetail (buyprice, parcode, returnsellbillid, returnsellbilldetailcatid, returnsellbilldetailproductid, returnsellbilldetailquantity, returnsellbilldetailprice, returnsellbilldetailtotalprice, conditions, note, pricetype, discountvalue, productunitid, buydiscount, buydiscounttype, storeid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($temreturnsellbilldetail->buyprice);
        $sqlQuery->set($temreturnsellbilldetail->parcode);
        $sqlQuery->setNumber($temreturnsellbilldetail->returnsellbillid);
        $sqlQuery->setNumber($temreturnsellbilldetail->returnsellbilldetailcatid);
        $sqlQuery->setNumber($temreturnsellbilldetail->returnsellbilldetailproductid);
        $sqlQuery->set($temreturnsellbilldetail->returnsellbilldetailquantity);
        $sqlQuery->set($temreturnsellbilldetail->returnsellbilldetailprice);
        $sqlQuery->set($temreturnsellbilldetail->returnsellbilldetailtotalprice);
        $sqlQuery->set($temreturnsellbilldetail->conditions);
        $sqlQuery->set($temreturnsellbilldetail->note);
        $sqlQuery->setNumber($temreturnsellbilldetail->pricetype);
        $sqlQuery->set($temreturnsellbilldetail->discountvalue);
        $sqlQuery->setNumber($temreturnsellbilldetail->productunitid);
        $sqlQuery->set($temreturnsellbilldetail->buydiscount);
        $sqlQuery->setNumber($temreturnsellbilldetail->buydiscounttype);
        $sqlQuery->setNumber($temreturnsellbilldetail->storeid);

        $id = $this->executeInsert($sqlQuery);
        $temreturnsellbilldetail->returnsellbilldetailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param TemreturnsellbilldetailMySql temreturnsellbilldetail
     */
    public function update($temreturnsellbilldetail) {
        $sql = 'UPDATE temreturnsellbilldetail SET buyprice = ?, parcode = ?, returnsellbillid = ?, returnsellbilldetailcatid = ?, returnsellbilldetailproductid = ?, returnsellbilldetailquantity = ?, returnsellbilldetailprice = ?, returnsellbilldetailtotalprice = ?, conditions = ?, note = ?, pricetype = ?, discountvalue = ?, productunitid = ?, buydiscount = ?, buydiscounttype = ?, storeid = ? WHERE returnsellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($temreturnsellbilldetail->buyprice);
        $sqlQuery->set($temreturnsellbilldetail->parcode);
        $sqlQuery->setNumber($temreturnsellbilldetail->returnsellbillid);
        $sqlQuery->setNumber($temreturnsellbilldetail->returnsellbilldetailcatid);
        $sqlQuery->setNumber($temreturnsellbilldetail->returnsellbilldetailproductid);
        $sqlQuery->set($temreturnsellbilldetail->returnsellbilldetailquantity);
        $sqlQuery->set($temreturnsellbilldetail->returnsellbilldetailprice);
        $sqlQuery->set($temreturnsellbilldetail->returnsellbilldetailtotalprice);
        $sqlQuery->set($temreturnsellbilldetail->conditions);
        $sqlQuery->set($temreturnsellbilldetail->note);
        $sqlQuery->setNumber($temreturnsellbilldetail->pricetype);
        $sqlQuery->set($temreturnsellbilldetail->discountvalue);
        $sqlQuery->setNumber($temreturnsellbilldetail->productunitid);
        $sqlQuery->set($temreturnsellbilldetail->buydiscount);
        $sqlQuery->setNumber($temreturnsellbilldetail->buydiscounttype);
        $sqlQuery->setNumber($temreturnsellbilldetail->storeid);

        $sqlQuery->setNumber($temreturnsellbilldetail->returnsellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM temreturnsellbilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBuyprice($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillid($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE returnsellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilldetailcatid($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE returnsellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilldetailproductid($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE returnsellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilldetailquantity($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE returnsellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilldetailprice($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE returnsellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilldetailtotalprice($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE returnsellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPricetype($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalue($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductunitid($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuydiscount($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE buydiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuydiscounttype($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE buydiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM temreturnsellbilldetail WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBuyprice($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillid($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE returnsellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilldetailcatid($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE returnsellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilldetailproductid($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE returnsellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilldetailquantity($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE returnsellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilldetailprice($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE returnsellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilldetailtotalprice($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE returnsellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPricetype($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalue($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductunitid($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuydiscount($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE buydiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuydiscounttype($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE buydiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM temreturnsellbilldetail WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return TemreturnsellbilldetailMySql
     */
    protected function readRow($row) {
        $temreturnsellbilldetail = new Temreturnsellbilldetail();

        $temreturnsellbilldetail->returnsellbilldetailid = isset($row['returnsellbilldetailid']) ? $row['returnsellbilldetailid'] : '';
        $temreturnsellbilldetail->buyprice = isset($row['buyprice']) ? $row['buyprice'] : '';
        $temreturnsellbilldetail->parcode = isset($row['parcode']) ? $row['parcode'] : '';
        $temreturnsellbilldetail->returnsellbillid = isset($row['returnsellbillid']) ? $row['returnsellbillid'] : '';
        $temreturnsellbilldetail->returnsellbilldetailcatid = isset($row['returnsellbilldetailcatid']) ? $row['returnsellbilldetailcatid'] : '';
        $temreturnsellbilldetail->returnsellbilldetailproductid = isset($row['returnsellbilldetailproductid']) ? $row['returnsellbilldetailproductid'] : '';
        $temreturnsellbilldetail->returnsellbilldetailquantity = isset($row['returnsellbilldetailquantity']) ? $row['returnsellbilldetailquantity'] : '';
        $temreturnsellbilldetail->returnsellbilldetailprice = isset($row['returnsellbilldetailprice']) ? $row['returnsellbilldetailprice'] : '';
        $temreturnsellbilldetail->returnsellbilldetailtotalprice = isset($row['returnsellbilldetailtotalprice']) ? $row['returnsellbilldetailtotalprice'] : '';
        $temreturnsellbilldetail->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $temreturnsellbilldetail->note = isset($row['note']) ? $row['note'] : '';
        $temreturnsellbilldetail->pricetype = isset($row['pricetype']) ? $row['pricetype'] : '';
        $temreturnsellbilldetail->discountvalue = isset($row['discountvalue']) ? $row['discountvalue'] : '';
        $temreturnsellbilldetail->productunitid = isset($row['productunitid']) ? $row['productunitid'] : '';
        $temreturnsellbilldetail->buydiscount = isset($row['buydiscount']) ? $row['buydiscount'] : '';
        $temreturnsellbilldetail->buydiscounttype = isset($row['buydiscounttype']) ? $row['buydiscounttype'] : '';
        $temreturnsellbilldetail->storeid = isset($row['storeid']) ? $row['storeid'] : '';

        return $temreturnsellbilldetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return TemreturnsellbilldetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>