<?php

/**
 * Class that operate on table 'temsellbilldetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-07-01 15:25
 */
class TemsellbilldetailMySqlDAO implements TemsellbilldetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return TemsellbilldetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM temsellbilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM temsellbilldetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param temsellbilldetail primary key
     */
    public function delete($sellbilldetailid) {
        $sql = 'DELETE FROM temsellbilldetail WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param TemsellbilldetailMySql temsellbilldetail
     */
    public function insert($temsellbilldetail) {
        $sql = 'INSERT INTO temsellbilldetail (buyprice, parcode, sellbillid, sellbilldetailcatid, sellbilldetailproductid, sellbilldetailquantity, sellbilldetailprice, sellbilldetailtotalprice, discountvalue, note, pricetype, sellbilldetaildate, productunitid, buydiscount, buydiscounttype, storeid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($temsellbilldetail->buyprice);
        $sqlQuery->set($temsellbilldetail->parcode);
        $sqlQuery->setNumber($temsellbilldetail->sellbillid);
        $sqlQuery->setNumber($temsellbilldetail->sellbilldetailcatid);
        $sqlQuery->setNumber($temsellbilldetail->sellbilldetailproductid);
        $sqlQuery->set($temsellbilldetail->sellbilldetailquantity);
        $sqlQuery->set($temsellbilldetail->sellbilldetailprice);
        $sqlQuery->set($temsellbilldetail->sellbilldetailtotalprice);
        $sqlQuery->set($temsellbilldetail->discountvalue);
        $sqlQuery->set($temsellbilldetail->note);
        $sqlQuery->setNumber($temsellbilldetail->pricetype);
        $sqlQuery->set($temsellbilldetail->sellbilldetaildate);
        $sqlQuery->setNumber($temsellbilldetail->productunitid);
        $sqlQuery->set($temsellbilldetail->buydiscount);
        $sqlQuery->setNumber($temsellbilldetail->buydiscounttype);
        $sqlQuery->setNumber($temsellbilldetail->storeid);

        $id = $this->executeInsert($sqlQuery);
        $temsellbilldetail->sellbilldetailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param TemsellbilldetailMySql temsellbilldetail
     */
    public function update($temsellbilldetail) {
        $sql = 'UPDATE temsellbilldetail SET buyprice = ?, parcode = ?, sellbillid = ?, sellbilldetailcatid = ?, sellbilldetailproductid = ?, sellbilldetailquantity = ?, sellbilldetailprice = ?, sellbilldetailtotalprice = ?, discountvalue = ?, note = ?, pricetype = ?, sellbilldetaildate = ?, productunitid = ?, buydiscount = ?, buydiscounttype = ?, storeid = ? WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($temsellbilldetail->buyprice);
        $sqlQuery->set($temsellbilldetail->parcode);
        $sqlQuery->setNumber($temsellbilldetail->sellbillid);
        $sqlQuery->setNumber($temsellbilldetail->sellbilldetailcatid);
        $sqlQuery->setNumber($temsellbilldetail->sellbilldetailproductid);
        $sqlQuery->set($temsellbilldetail->sellbilldetailquantity);
        $sqlQuery->set($temsellbilldetail->sellbilldetailprice);
        $sqlQuery->set($temsellbilldetail->sellbilldetailtotalprice);
        $sqlQuery->set($temsellbilldetail->discountvalue);
        $sqlQuery->set($temsellbilldetail->note);
        $sqlQuery->setNumber($temsellbilldetail->pricetype);
        $sqlQuery->set($temsellbilldetail->sellbilldetaildate);
        $sqlQuery->setNumber($temsellbilldetail->productunitid);
        $sqlQuery->set($temsellbilldetail->buydiscount);
        $sqlQuery->setNumber($temsellbilldetail->buydiscounttype);
        $sqlQuery->setNumber($temsellbilldetail->storeid);

        $sqlQuery->setNumber($temsellbilldetail->sellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM temsellbilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBuyprice($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillid($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailcatid($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE sellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailproductid($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE sellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailquantity($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE sellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailprice($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE sellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailtotalprice($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE sellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalue($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPricetype($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetaildate($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE sellbilldetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductunitid($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuydiscount($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE buydiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuydiscounttype($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE buydiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM temsellbilldetail WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBuyprice($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillid($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailcatid($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE sellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailproductid($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE sellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailquantity($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE sellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailprice($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE sellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailtotalprice($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE sellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalue($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPricetype($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetaildate($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE sellbilldetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductunitid($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuydiscount($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE buydiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuydiscounttype($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE buydiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM temsellbilldetail WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return TemsellbilldetailMySql
     */
    protected function readRow($row) {
        $temsellbilldetail = new Temsellbilldetail();

        $temsellbilldetail->buyprice = isset($row['buyprice']) ? $row['buyprice'] : '';
        $temsellbilldetail->parcode = isset($row['parcode']) ? $row['parcode'] : '';
        $temsellbilldetail->sellbilldetailid = isset($row['sellbilldetailid']) ? $row['sellbilldetailid'] : '';
        $temsellbilldetail->sellbillid = isset($row['sellbillid']) ? $row['sellbillid'] : '';
        $temsellbilldetail->sellbilldetailcatid = isset($row['sellbilldetailcatid']) ? $row['sellbilldetailcatid'] : '';
        $temsellbilldetail->sellbilldetailproductid = isset($row['sellbilldetailproductid']) ? $row['sellbilldetailproductid'] : '';
        $temsellbilldetail->sellbilldetailquantity = isset($row['sellbilldetailquantity']) ? $row['sellbilldetailquantity'] : '';
        $temsellbilldetail->sellbilldetailprice = isset($row['sellbilldetailprice']) ? $row['sellbilldetailprice'] : '';
        $temsellbilldetail->sellbilldetailtotalprice = isset($row['sellbilldetailtotalprice']) ? $row['sellbilldetailtotalprice'] : '';
        $temsellbilldetail->discountvalue = isset($row['discountvalue']) ? $row['discountvalue'] : '';
        $temsellbilldetail->note = isset($row['note']) ? $row['note'] : '';
        $temsellbilldetail->pricetype = isset($row['pricetype']) ? $row['pricetype'] : '';
        $temsellbilldetail->sellbilldetaildate = isset($row['sellbilldetaildate']) ? $row['sellbilldetaildate'] : '';
        $temsellbilldetail->productunitid = isset($row['productunitid']) ? $row['productunitid'] : '';
        $temsellbilldetail->buydiscount = isset($row['buydiscount']) ? $row['buydiscount'] : '';
        $temsellbilldetail->buydiscounttype = isset($row['buydiscounttype']) ? $row['buydiscounttype'] : '';
        $temsellbilldetail->storeid = isset($row['storeid']) ? $row['storeid'] : '';

        return $temsellbilldetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return TemsellbilldetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>