<?php

/**
 * Class that operate on table 'unit'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class UnitMySqlDAO implements UnitDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return UnitMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM unit WHERE unitId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM unit';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM unit ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param unit primary key
     */
    public function delete($unitId) {
        $sql = 'DELETE FROM unit WHERE unitId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($unitId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param UnitMySql unit
     */
    public function insert($unit) {
        $sql = 'INSERT INTO unit (unitName, unitSymbol, unitDescription, unitDate, conditions, userId) VALUES (?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($unit->unitName);
        $sqlQuery->set($unit->unitSymbol);
        $sqlQuery->setString2($unit->unitDescription);
        $sqlQuery->set($unit->unitDate);
        $sqlQuery->setNumber($unit->conditions);
        $sqlQuery->setNumber($unit->userId);

        $id = $this->executeInsert($sqlQuery);
        $unit->unitId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param UnitMySql unit
     */
    public function update($unit) {
        $sql = 'UPDATE unit SET unitName = ?, unitSymbol = ?, unitDescription = ?, unitDate = ?, conditions = ?, userId = ? WHERE unitId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($unit->unitName);
        $sqlQuery->set($unit->unitSymbol);
        $sqlQuery->setString2($unit->unitDescription);
        $sqlQuery->set($unit->unitDate);
        $sqlQuery->setNumber($unit->conditions);
        $sqlQuery->setNumber($unit->userId);

        $sqlQuery->setNumber($unit->unitId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM unit';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByUnitName($value) {
        $sql = 'SELECT * FROM unit WHERE unitName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUnitDescription($value) {
        $sql = 'SELECT * FROM unit WHERE unitDescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUnitDate($value) {
        $sql = 'SELECT * FROM unit WHERE unitDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM unit WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM unit WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByUnitName($value) {
        $sql = 'DELETE FROM unit WHERE unitName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUnitDescription($value) {
        $sql = 'DELETE FROM unit WHERE unitDescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUnitDate($value) {
        $sql = 'DELETE FROM unit WHERE unitDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM unit WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM unit WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return UnitMySql
     */
    protected function readRow($row) {
        $unit = new Unit();

        $unit->unitId = isset($row['unitId']) ? $row['unitId'] : '';
        $unit->unitName = isset($row['unitName']) ? $row['unitName'] : '';
        $unit->unitSymbol = isset($row['unitSymbol']) ? $row['unitSymbol'] : '';
        $unit->unitDescription = isset($row['unitDescription']) ? $row['unitDescription'] : '';

        $unit->unitDate = isset($row['unitDate']) ? $row['unitDate'] : '';
        $unit->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $unit->userId = isset($row['userId']) ? $row['userId'] : '';

        return $unit;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return UnitMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>