<?php

/**
 * Class that operate on table 'usergroupadmin'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-02-26 15:13
 */
class UsergroupadminMySqlDAO implements UsergroupadminDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return UsergroupadminMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM usergroupadmin WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM usergroupadmin';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM usergroupadmin ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param usergroupadmin primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM usergroupadmin WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param UsergroupadminMySql usergroupadmin
     */
    public function insert($usergroupadmin) {
        $sql = 'INSERT INTO usergroupadmin (propertyid, isallowed) VALUES (?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($usergroupadmin->propertyid);
        $sqlQuery->setNumber($usergroupadmin->isallowed);

        $id = $this->executeInsert($sqlQuery);
        $usergroupadmin->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param UsergroupadminMySql usergroupadmin
     */
    public function update($usergroupadmin) {
        $sql = 'UPDATE usergroupadmin SET propertyid = ?, isallowed = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($usergroupadmin->propertyid);
        $sqlQuery->setNumber($usergroupadmin->isallowed);

        $sqlQuery->setNumber($usergroupadmin->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM usergroupadmin';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByPropertyid($value) {
        $sql = 'SELECT * FROM usergroupadmin WHERE propertyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIsallowed($value) {
        $sql = 'SELECT * FROM usergroupadmin WHERE isallowed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByPropertyid($value) {
        $sql = 'DELETE FROM usergroupadmin WHERE propertyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIsallowed($value) {
        $sql = 'DELETE FROM usergroupadmin WHERE isallowed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return UsergroupadminMySql
     */
    protected function readRow($row) {
        $usergroupadmin = new Usergroupadmin();

        $usergroupadmin->id = $row['id'];
        $usergroupadmin->propertyid = $row['propertyid'];
        $usergroupadmin->isallowed = $row['isallowed'];
        //
        $usergroupadmin->propertyname = $row['propertyname'];
        $usergroupadmin->propertyparent = $row['propertyparent'];

        return $usergroupadmin;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return UsergroupadminMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    protected function executeUpdate($sqlQuery, $multiQuery = 0) {
        return QueryExecutor::executeUpdate($sqlQuery, $multiQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>