<?php
/**
 * Class that operate on table 'youtube_link'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2022-03-02 22:31
 */
class YoutubeLinkMySqlDAO implements YoutubeLinkDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return YoutubeLinkMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM youtube_link WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM youtube_link';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM youtube_link ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param youtubeLink primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM youtube_link WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param YoutubeLinkMySql youtubeLink
 	 */
	public function insert($youtubeLink){
		$sql = 'INSERT INTO youtube_link (url, status) VALUES (?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($youtubeLink->url);
		$sqlQuery->setNumber($youtubeLink->status);

		$id = $this->executeInsert($sqlQuery);	
		$youtubeLink->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param YoutubeLinkMySql youtubeLink
 	 */
	public function update($youtubeLink){
		$sql = 'UPDATE youtube_link SET url = ?, status = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($youtubeLink->url);
		$sqlQuery->setNumber($youtubeLink->status);

		$sqlQuery->setNumber($youtubeLink->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM youtube_link';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUrl($value){
		$sql = 'SELECT * FROM youtube_link WHERE url = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM youtube_link WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUrl($value){
		$sql = 'DELETE FROM youtube_link WHERE url = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM youtube_link WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return YoutubeLinkMySql 
	 */
	protected function readRow($row){
		$youtubeLink = new YoutubeLink();
		
		$youtubeLink->id = $row['id'];
		$youtubeLink->url = $row['url'];
		$youtubeLink->status = $row['status'];

		return $youtubeLink;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return YoutubeLinkMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>