<?php

/**
 * Class that operate on table 'productionoutmany'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-01-24 21:04
 */
class ProductionoutmanyMySqlExtDAO extends ProductionoutmanyMySqlDAO {

    public function queryAllExt($queryString = '') {
        $sql = 'SELECT productionoutmany.*,supplier.suppliername
                ,storeout.storeName as storeNameOut,storein.storeName as storeNameIn
                FROM productionoutmany
                join supplier ON supplier.supplierid = productionoutmany.supplier
                join store as storeout ON storeout.storeId=productionoutmany.outStore
                join store as storein ON storein.storeId=productionoutmany.inStore
                where 1 ' . $queryString;
        //echo $sql;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function insertWithId($productionoutmany) {
        $sql = 'INSERT INTO productionoutmany (id,outStore, inStore, supplier, comment, userid, sysDate, del,title,productionoutmanynum) VALUES (?, ?, ?, ?, ?, ?, ?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionoutmany->id);
        $sqlQuery->setNumber($productionoutmany->outStore);
        $sqlQuery->setNumber($productionoutmany->inStore);
        $sqlQuery->setNumber($productionoutmany->supplier);
        $sqlQuery->setString2($productionoutmany->comment);
        $sqlQuery->setNumber($productionoutmany->userid);
        $sqlQuery->set($productionoutmany->sysDate);
        $sqlQuery->setNumber($productionoutmany->del);
        $sqlQuery->set($productionoutmany->title);
        $sqlQuery->setNumber((int) $productionoutmany->productionoutmanynum);

        $id = $this->executeInsert($sqlQuery);
        $productionoutmany->id = $id;
        return $id;
    }

    public function countProductionoutmanynumValue($value) {
        $sql = 'SELECT count(productionoutmanynum) FROM productionoutmany WHERE productionoutmanynum = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->querySingleResult($sqlQuery);
    }

    public function getMaxValOfProductionoutmanynum($value) {
        $sql = 'SELECT Max(productionoutmanynum) FROM productionoutmany';
        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function getLastRow() {
        $sql = 'SELECT * FROM productionoutmany ORDER BY id DESC LIMIT 1';
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

}

?>