<?php

/**
 * Class that operate on table 'restaurantkitchenprint'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-05-26 15:04
 */
class RestaurantkitchenprintMySqlExtDAO extends RestaurantkitchenprintMySqlDAO {

    public function getLastTogetherNo() {
        $sql = 'SELECT togetherNo FROM restaurantkitchenprint where isPrinted = 0 ORDER BY togetherNo desc limit 1';
        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function getFirstNotPrintedTogetherNo() {
        $sql = 'SELECT togetherNo FROM restaurantkitchenprint where isPrinted = 0 ORDER BY togetherNo asc limit 1';
        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function getNewBillToPrint($queryString) {
        $sql = 'SELECT restaurantkitchenprint.*,product.productName as productName, productcat.productCatName as productCatName,restaurantorder.tableId,restaurantorder.daySreial,restaurantorder.billComment,restauranthall.name as hallName
                FROM restaurantkitchenprint
                join product on product.productId = restaurantkitchenprint.productId
                left join productcat on productcat.productCatId = product.productCatId
                left join restaurantorder on restaurantorder.id = restaurantkitchenprint.orderId
                Left join restauranttable on restauranttable.id = restaurantorder.tableId
                Left join restauranthall on restauranthall.id = restauranttable.hallid
                where isPrinted = 0
                ' . $queryString . '
                ORDER BY togetherNo asc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function markTogetherValAsPrinted($together, $queryString) {
        $sql = "UPDATE restaurantkitchenprint
                join product on product.productId = restaurantkitchenprint.productId
                SET isPrinted = 1
                WHERE togetherNo in($together) $queryString";
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOrderIdAndProductIdCount($orderId, $productId) {
        $sql = 'SELECT count(id) FROM restaurantkitchenprint where orderId = ' . $orderId . ' and productId =' . $productId . ' ';
        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function updateOrderIdEX($oldOrderId, $newOrderId) {
        $sql = "UPDATE restaurantkitchenprint
                SET orderId = $newOrderId
                WHERE orderId = $oldOrderId";
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function resetPrinters() {
        $sql = "TRUNCATE restaurantkitchenprint";
        //$sql = "update restaurantkitchenprint set isPrinted = 1";
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

}

?>