<?php

/**
 * Class that operate on table 'returnsellbilldetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ReturnsellbilldetailMySqlExtDAO extends ReturnsellbilldetailMySqlDAO {

    public function queryWithReturnsellbillId($returnsellbillid) {
        $sql = 'SELECT returnsellbilldetail.*, product.productName, store.storeName , unit.unitName ,productcat.productCatName
                ,size.name as sizeName,color.name as colorName,productserailid,productserial.don
		 FROM returnsellbilldetail JOIN product
		 ON returnsellbilldetail.returnsellbilldetailproductid = product.productId
		 left JOIN productunit
		 ON returnsellbilldetail.productunitid = productunit.productunitid
		 left JOIN unit
		 ON unit.unitId = productunit.unitid
		  join productcat
		  on productcat.productCatId=product.productCatId

		   left join store
		  on store.storeid=returnsellbilldetail.storeid
                  left join sizecolor as size on size.id = returnsellbilldetail.sizeid
                left join sizecolor as color on color.id = returnsellbilldetail.colorid

                left join productserial on (productserial.serialnumber=returnsellbilldetail.parcode and productserial.productid=returnsellbilldetail.returnsellbilldetailproductid and returnsellbilldetail.sizeid=productserial.sizeid and returnsellbilldetail.colorid=productserial.colorid)

		 WHERE returnsellbilldetail.returnsellbillid = ' . $returnsellbillid . '
                 order by returnsellbilldetail.returnsellbilldetailid asc';

        // print_r($sql.'<br>');
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithReturnsellbillIdforproft($returnsellbillid) {
        $sql = 'SELECT returnsellbilldetail.*, product.productName, store.storeName , unit.unitName ,productcat.productCatName,productcat.discounttype,productcat.buydiscount,productunit.productnumber
		 FROM returnsellbilldetail JOIN product
		 ON returnsellbilldetail.returnsellbilldetailproductid = product.productId
		 left JOIN productunit
		 ON returnsellbilldetail.productunitid = productunit.productunitid
		 left JOIN unit
		 ON unit.unitId = productunit.unitid
		  join productcat
		  on productcat.productCatId=product.productCatId

		   left join store
		  on store.storeid=returnsellbilldetail.storeid
		 WHERE returnsellbilldetail.returnsellbillid = ' . $returnsellbillid . '';

        // print_r($sql.'<br>');
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateAndConditions($startDate, $endDate) {
        $sql = 'SELECT returnsellbilldetail.*,product.overAllAveragePrice as generalPrice
		 FROM returnsellbilldetail
                 JOIN returnsellbill ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
                 join product on product.productId = returnsellbilldetail.returnsellbilldetailproductid
		 where returnsellbill.conditions = 0
		 and returnsellbill.returnsellbilldate >= "' . $startDate . '" and returnsellbill.returnsellbilldate <= "' . $endDate . '"';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateAndConditionsExt($startDate, $endDate) {
        $sql = 'SELECT returnsellbilldetail.returnsellbilldetailproductid,
		returnsellbilldetail.returnsellbilldetailquantity,
		returnsellbilldetail.productunitid,
		returnsellbilldetail.buyprice,
		returnsellbilldetail.buydiscount,
		returnsellbilldetail.buydiscounttype

		 FROM returnsellbilldetail
		 JOIN returnsellbill
		 ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
		 where returnsellbill.conditions = 0
		 and returnsellbill.returnsellbilldate >= "' . $startDate . '" and returnsellbill.returnsellbilldate <= "' . $endDate . '"';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateAndConditionsAndProductId($startDate, $endDate, $productid) {
        $sql = 'SELECT returnsellbilldetail.*
		 FROM returnsellbilldetail JOIN returnsellbill
		 ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
		 where returnsellbill.conditions = 0
		 and returnsellbill.returnsellbilldate
		 >= "' . $startDate . '" and returnsellbill.returnsellbilldate <= "' . $endDate . '"
		 and returnsellbilldetailproductid =' . $productid . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateAndConditionsAndProductIdExt($startDate, $endDate, $productid) {
        $sql = 'SELECT
		 returnsellbilldetail.returnsellbilldetailquantity,
		 returnsellbilldetail.returnsellbilldetailprice,
		 returnsellbilldetail.returnsellbilldetailtotalprice,
		 returnsellbilldetail.discountvalue,
		 returnsellbilldetail.productunitid,
		 returnsellbill.returnsellbilltotalbill,
		 returnsellbill.returnsellbilldiscount,
		 returnsellbill.returnsellbilldiscounttype,
		 returnsellbilldetail.buyprice,
                 returnsellbilldetail.lastbuyprice,
                 returnsellbilldetail.meanbuyprice,
                 returnsellbilldetail.lastbuyprice_withDiscount,
                 returnsellbilldetail.meanbuyprice_withDiscount,
                 returnsellbilldetail.lastbuyprice_withTax,
                 returnsellbilldetail.meanbuyprice_withTax,
                 returnsellbill.returnsellbilldate as note

		 FROM returnsellbilldetail JOIN returnsellbill
		 ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
		 where returnsellbill.conditions = 0
		 and returnsellbill.returnsellbilldate
		 >= "' . $startDate . '" and returnsellbill.returnsellbilldate <= "' . $endDate . '"
		 and returnsellbilldetailproductid in(' . $productid . ')';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateAndConditionsAndProductIdExtNew($queryString) {
        $sql = 'SELECT
		 returnsellbilldetail.returnsellbilldetailquantity,
		 returnsellbilldetail.returnsellbilldetailprice,
		 returnsellbilldetail.returnsellbilldetailtotalprice,
		 returnsellbilldetail.discountvalue,
		 returnsellbilldetail.productunitid,
		 returnsellbill.returnsellbilltotalbill,
		 returnsellbill.returnsellbilldiscount,
		 returnsellbill.returnsellbilldiscounttype
		 , returnsellbilldetail.buyprice

		 FROM returnsellbilldetail JOIN returnsellbill
		 ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
		 where returnsellbill.conditions = 0
                 ' . $queryString . '
		 ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateAndConditionsAndProductIdExtandstorid($startDate, $endDate, $productid, $storid) {
        $sql = 'SELECT
		 returnsellbilldetail.returnsellbilldetailquantity,
		 returnsellbilldetail.returnsellbilldetailprice,
		 returnsellbilldetail.returnsellbilldetailtotalprice,
		 returnsellbilldetail.discountvalue,
		 returnsellbilldetail.productunitid,
		 returnsellbill.returnsellbilltotalbill,
		 returnsellbill.returnsellbilldiscount,
		 returnsellbill.returnsellbilldiscounttype
		 , returnsellbilldetail.buyprice

		 FROM returnsellbilldetail JOIN returnsellbill
		 ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
		 where returnsellbill.conditions = 0
		 and returnsellbill.returnsellbilldate
		 >= "' . $startDate . '" and returnsellbill.returnsellbilldate <= "' . $endDate . '"
		 and returnsellbilldetailproductid =' . $productid . '

		 and (returnsellbilldetail.storeid= ' . $storid . ' or returnsellbill.returnsellbillstoreid=' . $storid . ') ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateAndConditionsAndProductIdExtandstoridNew($queryString) {
        $sql = 'SELECT
		 returnsellbilldetail.returnsellbilldetailquantity,
		 returnsellbilldetail.returnsellbilldetailprice,
		 returnsellbilldetail.returnsellbilldetailtotalprice,
		 returnsellbilldetail.discountvalue,
		 returnsellbilldetail.productunitid,
		 returnsellbill.returnsellbilltotalbill,
		 returnsellbill.returnsellbilldiscount,
		 returnsellbill.returnsellbilldiscounttype
		 , returnsellbilldetail.buyprice

		 FROM returnsellbilldetail JOIN returnsellbill
		 ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
		 where returnsellbill.conditions = 0
		 ' . $queryString . ' ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryQuantityWithProduct($productId) {
        $sql = 'SELECT SUM(returnsellbilldetail.returnsellbilldetailquantity) as sumQuantity
		 FROM returnsellbilldetail JOIN returnsellbill
		 ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
		 where returnsellbill.conditions = 0
		 and returnsellbilldetail.returnsellbilldetailproductid = ' . $productId . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function queryQuantityWithProductAndDate($productId, $startDate, $endDate) {
        $sql = 'SELECT SUM(returnsellbilldetail.returnsellbilldetailquantity) as sumQuantity
		 FROM returnsellbilldetail JOIN returnsellbill
		 ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
		 where returnsellbill.conditions = 0
		 and returnsellbilldetail.returnsellbilldetailproductid = ' . $productId . '
		 and returnsellbill.returnsellbilldate >= "' . $startDate . '" and returnsellbill.returnsellbilldate <= "' . $endDate . '"';
        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function queryWithProductIdAndClientIdAndUnit($ProductId, $ClientId, $productunitid) {

        $sql = 'SELECT returnsellbilldetail.*, product.productName, unit.unitName
		,productcat.productCatName, returnsellbilldate
		  FROM returnsellbilldetail JOIN returnsellbill
		 ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
		  JOIN product
		 ON returnsellbilldetail.returnsellbilldetailproductid = product.productId
		  JOIN productunit
		 ON returnsellbilldetail.productunitid = productunit.productunitid
		 JOIN unit
		 ON unit.unitId = productunit.unitid
		  JOIN productcat
		  ON productcat.productCatId=product.productCatId
		WHERE returnsellbilldetail.returnsellbilldetailproductid = ' . $ProductId . '
		 AND returnsellbilldetail.productunitid = ' . $productunitid . '
		 AND returnsellbill.returnsellbillclientid = ' . $ClientId . '
		 AND returnsellbill.conditions = 0
		 order by returnsellbilldetailid desc limit 1';

        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function countProductInSellBill($sellBillId) {
        $sql = 'SELECT SUM(returnsellbilldetailquantity) as sumQuantity
		  FROM returnsellbilldetail JOIN returnsellbill
		 ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid

		WHERE returnsellbilldetail.returnsellbillid = ' . $sellBillId . ' ';

        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function queryAllnothaveuintid() {
        $sql = 'SELECT * FROM returnsellbilldetail where returnsellbilldetail.productunitid not in(

		SELECT productunitid FROM `productunit`  )';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function updateproductunit($productunitid, $returnsellbilldetailid) {
        $sql = 'UPDATE returnsellbilldetail SET  productunitid = ' . $productunitid . '   WHERE returnsellbilldetailid = ' . $returnsellbilldetailid . '';

        //print_r('<br>'.$sql);

        $sqlQuery = new SqlQuery($sql);



        return $this->executeUpdate($sqlQuery);
    }

    public function queryAllnothavestor($start, $end) {
        $sql = 'SELECT * FROM returnsellbilldetail where storeid =0  LIMIT ' . $start . ' , ' . $end . ' ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function updatestoreid($storeid, $returnsellbilldetailid) {
        $sql = 'UPDATE returnsellbilldetail SET  storeid = ' . $storeid . ' WHERE returnsellbilldetailid = ' . $returnsellbilldetailid . '';

        //print_r('<br>'.$sql);

        $sqlQuery = new SqlQuery($sql);



        return $this->executeUpdate($sqlQuery);
    }

    public function getsumdiscount($returnsellbillid) {
        $sql = 'SELECT sum(discountvalue) FROM returnsellbilldetail where returnsellbillid=' . $returnsellbillid . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function queryAllGeneral($queryString) {
        if (strpos($queryString, "where") === false) { // no where use it before and that is coming without where
            $queryString = " where 1 " . $queryString;
        }
        $sql = 'SELECT  returnsellbilldetail.*,returnsellbillclientid as clientid,client.clientname,product.productName as productName,product.productBuyPrice as storeid,returnsellbill.returnsellbilltotalbill as parcode,returnsellbill.returnsellbillaftertotalbill as note,productcat.productCatName,product.productCatId,returnsellbill.userid
		 FROM returnsellbilldetail
                 left JOIN returnsellbill ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
                 left join client on client.clientid = returnsellbill.returnsellbillclientid
                 left join product on product.productId = returnsellbilldetail.returnsellbilldetailproductid
                 left join productcat on productcat.productCatId = product.productCatId
		 ' . $queryString . ' AND returnsellbill.conditions = 0
                 order by returnsellbilldetail.returnsellbilldetailproductid'; //AND returnsellbill.deletedsellid=0
        //echo $sql;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function returnsellbillWithProducts($queryString) {
        $sql = 'SELECT  returnsellbilldetail.*,product.productName as productName,product.productBuyPrice as storeid,returnsellbill.returnsellbilltotalbill as parcode,returnsellbill.returnsellbillaftertotalbill as note
                FROM returnsellbilldetail JOIN returnsellbill
		 ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
                join client on client.clientid = returnsellbill.returnsellbillclientid
                join goverarea on goverarea.clientareaid = client.clientareaid
                join clientarea on clientarea.id = client.clientareaid
                join government on government.governmetid = goverarea.governmentid
                join product on product.productId = returnsellbilldetail.returnsellbilldetailproductid
		WHERE 1 ' . $queryString . ' AND returnsellbill.conditions = 0 ';


        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllGeneralPriceType($queryString) {
        $sql = 'SELECT returnsellbilldetail.*,product.productName as productName,unit.unitId as unitid,unit.unitName as unitName
                FROM returnsellbilldetail
                join productunit on productunit.productunitid = returnsellbilldetail.productunitid
                join unit on unit.unitId = productunit.unitid
                join returnsellbill on returnsellbill.returnsellbillid = returnsellbilldetail.returnsellbillid
                join product on product.productId = returnsellbilldetail.returnsellbilldetailproductid ' . $queryString . '
                AND returnsellbill.conditions = 0 order by returnsellbilldetail.returnsellbilldetailproductid';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllGeneral2($queryString, $clientid) {
        $sql = 'SELECT client.clientname as clientname ,  returnsellbilldetail.*,product.productName as productName,product.productBuyPrice as storeid,returnsellbill.returnsellbilltotalbill as parcode,returnsellbill.returnsellbillaftertotalbill as note
		 FROM returnsellbilldetail JOIN returnsellbill
		 ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
                 join product on product.productId = returnsellbilldetail.returnsellbilldetailproductid
                 join client on client.clientid = returnsellbill.returnsellbillclientid
		 ' . $queryString . ' AND returnsellbill.conditions = 0
                 AND client.clientid  = ' . $clientid . '
                 AND returnsellbill.deletedsellid=0 order by returnsellbilldetail.returnsellbilldetailproductid';
        //echo $sql;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllGeneral3($queryString, $productid) {
        $sql = 'SELECT  client.clientname as clientname , client.clientid as clientid, returnsellbilldetail.*,product.productName as productName,product.productBuyPrice as storeid,returnsellbill.returnsellbilltotalbill as parcode,returnsellbill.returnsellbillaftertotalbill as note
		 FROM returnsellbilldetail JOIN returnsellbill
		 ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
                 join product on product.productId = returnsellbilldetail.returnsellbilldetailproductid
                 join client on client.clientid = returnsellbill.returnsellbillclientid
		 ' . $queryString . ' AND returnsellbill.conditions = 0
                 AND product.productId   = ' . $productid . '
                 AND returnsellbill.deletedsellid=0 order by returnsellbilldetail.returnsellbilldetailproductid';
        //echo $sql;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllGeneralSimple($queryString) {
        $sql = 'SELECT returnsellbilldetail.returnsellbilldetailquantity,returnsellbilldetail.productunitid,returnsellbill.returnsellbillid,returnsellbill.returnsellbilldate,clientname as discountvalue,storeName as note
		 FROM returnsellbilldetail
                 JOIN returnsellbill ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
                 join client on returnsellbill.returnsellbillclientid = client.clientid
                 join store on returnsellbilldetail.storeid = store.storeId
		 ' . $queryString . ' AND returnsellbill.conditions = 0
                 AND returnsellbill.deletedsellid=0 order by returnsellbilldetail.returnsellbilldetailproductid';
        //echo $sql;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryBillNoOfPecies($billid) {
        $sql = 'SELECT sum(returnsellbilldetail.returnsellbilldetailquantity) as note
        FROM returnsellbilldetail WHERE returnsellbillid = ' . $billid;
        $sqlQuery = new SqlQuery($sql);
        //echo $sql . "<br/>";
        return $this->getRow($sqlQuery);
    }

    public function queryAllNotDel($queryString) {
        $sql = 'SELECT returnsellbilldetail.*,returnsellbill.returnsellbilldate
		 FROM returnsellbilldetail
                 JOIN returnsellbill ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
		 where returnsellbill.conditions = 0
		 ' . $queryString;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillidEX($returnsellbillid, $queryString = '') {
        $sql = 'SELECT * FROM returnsellbilldetail WHERE returnsellbillid = ' . $returnsellbillid . ' ' . $queryString . ' ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryReturnSellBill($productId) {
        $sql = 'SELECT  returnsellbilldetail.*,returnsellbillclientid as clientid,client.clientname,product.productName as productName,product.productBuyPrice as storeid,returnsellbill.returnsellbilltotalbill as parcodeTotal,returnsellbill.returnsellbillaftertotalbill as note,productcat.productCatName,product.productCatId,returnsellbill.userid
		 FROM returnsellbilldetail
                 left JOIN returnsellbill ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid
                 left join client on client.clientid = returnsellbill.returnsellbillclientid
                 left join product on product.productId = returnsellbilldetail.returnsellbilldetailproductid
                 left join productcat on productcat.productCatId = product.productCatId
		 WHERE returnsellbilldetail.returnsellbilldetailproductid = ' . $productId . ' AND returnsellbill.conditions = 0
                 order by returnsellbilldetail.returnsellbilldetailproductid'; //AND returnsellbill.deletedsellid=0
//        echo $sql;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function sellbillReturnDETAILSCats($sellbillreturndate = '') {
        $sql = 'SELECT productcat.productCatId,productcat.productCatName,returnsellbill.returnsellbilltotalbill as parcodeTotal,returnsellbill.returnsellbillaftertotalbill as note,returnsellbilldetail.* FROM productcat
                left JOIN returnsellbilldetail ON returnsellbilldetail.returnsellbilldetailcatid = productcat.productCatId
                left JOIN returnsellbill ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid where returnsellbill.conditions = 0 ' . $sellbillreturndate . ' ';
        $sqlQuery = new SqlQuery($sql);
//        print($sql);
        return $this->getList($sqlQuery);
    }

    public function sellbillReturnDETAILSClients($sellbillreturndate = '') {
        $sql = 'SELECT client.clientid,client.clientname as clientname,returnsellbill.returnsellbillclientid,returnsellbilldetail.* ,returnsellbill.returnsellbilltotalbill as parcodeTotal,returnsellbill.returnsellbillaftertotalbill as note
		 FROM client
                 left JOIN returnsellbill ON returnsellbill.returnsellbillclientid = client.clientid
		        left JOIN returnsellbilldetail ON returnsellbilldetail.returnsellbillid = returnsellbill.returnsellbillid WHERE returnsellbilldetail.returnsellbillid IS NOT NULL ' . $sellbillreturndate . ' ';
        $sqlQuery = new SqlQuery($sql);
//        print($sql);
        return $this->getList($sqlQuery);
    }

    public function getproductpricebuy($productId, $storereportmodelid) {
        $sql = 'SELECT returnsellbilldetail.*
        FROM returnsellbilldetail
        WHERE returnsellbilldetailproductid = ' . $productId . ' and returnsellbillid=' . $storereportmodelid;
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

}

?>