<?php

/**
 * Class that operate on table 'transfermoney'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class TransfermoneyMySqlExtDAO extends TransfermoneyMySqlDAO {

    public function queryWithOrder() {
        $sql = 'SELECT transfermoney.*, savefrom.savename as savefromname,
		saveto.savename as savetoname
		FROM transfermoney JOIN save savefrom
		ON transfermoney.saveidfrom = savefrom.saveid JOIN save saveto
		ON transfermoney.saveidto = saveto.saveid
		where savefrom.conditions = 0 and saveto.conditions = 0
		order by transfermoneyid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithOrderLimited($start, $end) {
        $sql = 'SELECT transfermoney.*, savefrom.savename as savefromname,
		saveto.savename as savetoname
		FROM transfermoney JOIN save savefrom
		ON transfermoney.saveidfrom = savefrom.saveid JOIN save saveto
		ON transfermoney.saveidto = saveto.saveid
		where savefrom.conditions = 0 and saveto.conditions = 0
		order by transfermoneyid desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDate($startDate, $endDate) {
        $sql = 'SELECT transfermoney.*, savefrom.savename as savefromname,
		saveto.savename as savetoname
		FROM transfermoney JOIN save savefrom
		ON transfermoney.saveidfrom = savefrom.saveid JOIN save saveto
		ON transfermoney.saveidto = saveto.saveid
		where savefrom.conditions = 0 and saveto.conditions = 0
		and  transfermoneydate >= "' . $startDate . '" and transfermoneydate <= "' . $endDate . '"
		order by transfermoneyid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithQueryString($queryString = '') {
        $sql = 'SELECT transfermoney.*, savefrom.savename as savefromname,
		saveto.savename as savetoname
		FROM transfermoney JOIN save savefrom
		ON transfermoney.saveidfrom = savefrom.saveid JOIN save saveto
		ON transfermoney.saveidto = saveto.saveid
		where savefrom.conditions = 0 and saveto.conditions = 0
                ' . $queryString . '
		order by transfermoneyid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithOneDate($condition, $date) {
        $sql = 'SELECT transfermoney.*, savefrom.savename as savefromname,
		saveto.savename as savetoname
		FROM transfermoney JOIN save savefrom
		ON transfermoney.saveidfrom = savefrom.saveid JOIN save saveto
		ON transfermoney.saveidto = saveto.saveid
		where savefrom.conditions = 0 and saveto.conditions = 0
		and  transfermoneydate  ' . $condition . '"' . $date . '"
		order by transfermoneyid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateLimited($start, $end, $startDate, $endDate) {
        $sql = 'SELECT transfermoney.*, savefrom.savename as savefromname,
		saveto.savename as savetoname
		FROM transfermoney JOIN save savefrom
		ON transfermoney.saveidfrom = savefrom.saveid JOIN save saveto
		ON transfermoney.saveidto = saveto.saveid
		where savefrom.conditions = 0 and saveto.conditions = 0
		and  transfermoneydate >= "' . $startDate . '" and transfermoneydate <= "' . $endDate . '"
		order by transfermoneyid desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function updateCondition($transfermoney) {
        $sql = 'UPDATE transfermoney SET  transfermoneydate = ?, userid = ?, conditions = ? WHERE transfermoneyid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($transfermoney->transfermoneydate);
        $sqlQuery->setNumber($transfermoney->userid);
        $sqlQuery->setNumber($transfermoney->conditions);

        $sqlQuery->setNumber($transfermoney->transfermoneyid);
        return $this->executeUpdate($sqlQuery);
    }

    public function loadTransfermoneyById($transfermoneyid) {
        $sql = 'SELECT transfermoney.*, savefrom.savename as savefromname,
			saveto.savename as savetoname
			FROM transfermoney JOIN save savefrom
			ON transfermoney.saveidfrom = savefrom.saveid JOIN save saveto
			ON transfermoney.saveidto = saveto.saveid
			where savefrom.conditions = 0 and saveto.conditions = 0
			and transfermoneyid =' . $transfermoneyid . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

}

?>